/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.jmx.InstallerMBean;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.RetryHandler;
import org.apache.sling.installer.core.impl.DefaultTransformer;
import org.apache.sling.installer.core.impl.InstallerMBeanImpl;
import org.apache.sling.installer.core.impl.InternalService;
import org.apache.sling.installer.core.impl.OsgiInstallerImpl;
import org.apache.sling.installer.core.impl.tasks.BundleTaskCreator;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    public static final String VENDOR = "The Apache Software Foundation";
    private List<InternalService> services = new ArrayList<InternalService>();
    private List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private OsgiInstallerImpl osgiControllerService;
    private ServiceRegistration osgiControllerServiceReg;

    public void start(BundleContext context) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Apache Sling Installer Controller Service");
        props.put("service.vendor", VENDOR);
        this.osgiControllerService = new OsgiInstallerImpl(context);
        this.registerServices(context);
        this.osgiControllerService.start();
        String[] serviceInterfaces = new String[]{OsgiInstaller.class.getName(), InfoProvider.class.getName(), ResourceChangeListener.class.getName(), RetryHandler.class.getName()};
        this.osgiControllerServiceReg = context.registerService(serviceInterfaces, (Object)this.osgiControllerService, props);
        this.registerJmxBean(context);
    }

    public void stop(BundleContext context) {
        if (this.osgiControllerService != null) {
            this.osgiControllerService.deactivate();
            this.osgiControllerService = null;
        }
        if (this.osgiControllerServiceReg != null) {
            this.osgiControllerServiceReg.unregister();
            this.osgiControllerServiceReg = null;
        }
        for (ServiceRegistration reg : this.registrations) {
            reg.unregister();
        }
        this.registrations.clear();
        for (InternalService service : this.services) {
            service.deactivate();
        }
        this.services.clear();
    }

    private void registerJmxBean(BundleContext context) throws MalformedObjectNameException {
        Hashtable<String, String> jmxProps = new Hashtable<String, String>();
        jmxProps.put("type", "Installer");
        jmxProps.put("name", "Sling OSGi Installer");
        Hashtable<String, Object> mbeanProps = new Hashtable<String, Object>();
        mbeanProps.put("service.description", "Apache Sling Installer Controller Service");
        mbeanProps.put("service.vendor", VENDOR);
        mbeanProps.put("jmx.objectname", new ObjectName("org.apache.sling.installer", jmxProps));
        ServiceRegistration mbeanReg = context.registerService(new String[]{InstallerMBean.class.getName(), InstallationListener.class.getName()}, (Object)new InstallerMBeanImpl(this.osgiControllerService), mbeanProps);
        this.registrations.add(mbeanReg);
    }

    private void registerServices(BundleContext context) throws Exception {
        Class[] serviceClasses;
        for (Class serviceClass : serviceClasses = new Class[]{BundleTaskCreator.class, DefaultTransformer.class}) {
            InternalService service = (InternalService)serviceClass.newInstance();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.description", service.getDescription());
            ((Dictionary)props).put("service.vendor", VENDOR);
            ((Dictionary)props).put("service.ranking", new Integer(-100));
            String[] serviceInterfaces = service instanceof ResourceTransformer && service instanceof InstallTaskFactory ? new String[]{ResourceTransformer.class.getName(), InstallTaskFactory.class.getName()} : (service instanceof ResourceTransformer ? new String[]{ResourceTransformer.class.getName()} : (service instanceof InstallTaskFactory ? new String[]{InstallTaskFactory.class.getName()} : null));
            if (serviceInterfaces == null) continue;
            this.services.add(service);
            service.init(context, this.osgiControllerService, this.osgiControllerService);
            this.registrations.add(context.registerService(serviceInterfaces, (Object)service, props));
        }
    }
}

