/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.artifacts;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactWriter;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.MavenPomSupplierWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMavenRepositoryArtifactsDeployer
implements ArtifactsDeployer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File artifactsDirectory;

    public LocalMavenRepositoryArtifactsDeployer(@NotNull File outputDirectory) {
        this.artifactsDirectory = outputDirectory;
        if (!this.artifactsDirectory.exists()) {
            this.artifactsDirectory.mkdirs();
        }
    }

    @NotNull
    public File getBaseDirectory() {
        return this.artifactsDirectory;
    }

    @Override
    @NotNull
    public String deploy(@NotNull ArtifactWriter artifactWriter, @Nullable String runmode, @NotNull ArtifactId id) throws IOException {
        Objects.requireNonNull(artifactWriter, "Null ArtifactWriter can not install an artifact to a Maven repository.");
        Objects.requireNonNull(id, "Bundle can not be installed to a Maven repository without specifying a valid id.");
        File targetDir = this.artifactsDirectory;
        StringTokenizer tokenizer = new StringTokenizer(id.getGroupId(), ".");
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken();
            targetDir = new File(targetDir, current);
        }
        targetDir = new File(targetDir, id.getArtifactId());
        targetDir = new File(targetDir, id.getVersion());
        targetDir.mkdirs();
        File targetFile = new File(targetDir, id.toMvnName());
        this.logger.info("Writing data to {}...", (Object)targetFile);
        try (Closeable targetStream = new FileOutputStream(targetFile);){
            artifactWriter.write((OutputStream)targetStream);
        }
        this.logger.info("Data successfully written to {}.", (Object)targetFile);
        targetFile = new File(targetDir, String.format("%s-%s.pom", id.getArtifactId(), id.getVersion()));
        if (!targetFile.exists()) {
            targetStream = new FileWriter(targetFile);
            try {
                new MavenPomSupplierWriter(id).write((FileWriter)targetStream);
            }
            finally {
                ((OutputStreamWriter)targetStream).close();
            }
        }
        return targetFile.toString();
    }
}

