/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPathMapping
implements PathMapping {
    private final Map<String, String> links = new HashMap<String, String>();
    private final Map<String, String> reverseLinks = new HashMap<String, String>();

    public MultiPathMapping link(@NotNull String src, @NotNull String dst) {
        this.links.put(src, dst);
        this.reverseLinks.put(dst, src);
        return this;
    }

    @NotNull
    public MultiPathMapping merge(@Nullable MultiPathMapping base) {
        if (base != null) {
            this.links.putAll(base.links);
            this.reverseLinks.putAll(base.reverseLinks);
        }
        return this;
    }

    @Override
    @NotNull
    public String map(@NotNull String path) {
        return this.map(path, false);
    }

    @Override
    @NotNull
    public String map(@NotNull String path, boolean reverse) {
        if (path.length() == 0 || "/".equals(path)) {
            return path;
        }
        Map<String, String> lookup = reverse ? this.reverseLinks : this.links;
        String[] segs = Text.explode((String)path, (int)47);
        String ret = "";
        for (String name : segs) {
            String link = lookup.get(ret = ret + "/" + name);
            if (link == null) continue;
            ret = link;
        }
        return ret;
    }
}

