/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.Iterator;
import java.util.Stack;
import org.apache.sling.api.resource.Resource;

public class ResourceIterator
implements Iterator<Resource> {
    private final String folderResourceType;
    private final boolean includeFolders;
    private final boolean includeLeafs;
    private final boolean includeRoot = false;
    private final String rootPath;
    private Stack<Iterator<Resource>> folderIterators = new Stack();
    private Resource currentFolder;
    private Iterator<Resource> currentIterator;
    private Resource next;

    public ResourceIterator(Resource root, String folderResourceType, boolean includeFolders, boolean includeLeafs) {
        this.folderResourceType = folderResourceType;
        this.includeFolders = includeFolders;
        this.includeLeafs = includeLeafs;
        this.rootPath = root.getPath();
        this.currentFolder = root;
        this.currentIterator = this.currentFolder.listChildren();
        this.next = this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Resource next() {
        Resource result = this.next;
        this.next = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    Resource seek() {
        Resource res;
        while ((res = this.seekAll()) != null) {
            if (this.rootPath.equals(res.getPath())) continue;
            if (this.includeFolders && res.isResourceType(this.folderResourceType)) {
                return res;
            }
            if (!this.includeLeafs || res.isResourceType(this.folderResourceType)) continue;
            return res;
        }
        return null;
    }

    Resource seekAll() {
        while (this.currentIterator != null) {
            if (this.currentIterator.hasNext()) {
                Resource res = this.currentIterator.next();
                if (res.isResourceType(this.folderResourceType)) {
                    this.folderIterators.push(this.currentIterator);
                    this.currentFolder = res;
                    this.currentIterator = this.currentFolder.listChildren();
                    continue;
                }
                return res;
            }
            Resource folder = this.currentFolder;
            this.currentFolder = this.currentFolder.getParent();
            this.currentIterator = this.folderIterators.empty() ? null : this.folderIterators.pop();
            return folder;
        }
        return null;
    }
}

