/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.AbstractServiceWithBackgroundCheck;
import org.apache.sling.discovery.commons.providers.spi.base.ClusterSyncHistory;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.apache.sling.discovery.commons.providers.util.LogSilencer;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ClusterSyncService.class, SyncTokenService.class}, property={"service.vendor=The Apache Software Foundation"})
public class SyncTokenService
extends AbstractServiceWithBackgroundCheck
implements ClusterSyncService {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected DiscoveryLiteConfig commonsConfig;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected SlingSettingsService settingsService;
    protected ClusterSyncHistory clusterSyncHistory = new ClusterSyncHistory();
    private final LogSilencer logSilencer = new LogSilencer(this.logger);

    public static SyncTokenService testConstructorAndActivate(DiscoveryLiteConfig commonsConfig, ResourceResolverFactory resourceResolverFactory, SlingSettingsService settingsService) {
        SyncTokenService service = SyncTokenService.testConstructor(commonsConfig, resourceResolverFactory, settingsService);
        service.activate();
        return service;
    }

    public static SyncTokenService testConstructor(DiscoveryLiteConfig commonsConfig, ResourceResolverFactory resourceResolverFactory, SlingSettingsService settingsService) {
        SyncTokenService service = new SyncTokenService();
        if (commonsConfig == null) {
            throw new IllegalArgumentException("commonsConfig must not be null");
        }
        if (resourceResolverFactory == null) {
            throw new IllegalArgumentException("resourceResolverFactory must not be null");
        }
        if (settingsService == null) {
            throw new IllegalArgumentException("settingsService must not be null");
        }
        service.commonsConfig = commonsConfig;
        service.resourceResolverFactory = resourceResolverFactory;
        service.settingsService = settingsService;
        return service;
    }

    @Activate
    protected void activate() {
        this.slingId = this.settingsService.getSlingId();
        this.logger.info("activate: activated with slingId=" + this.slingId);
    }

    public void setConsistencyHistory(ClusterSyncHistory consistencyHistory) {
        this.clusterSyncHistory = consistencyHistory;
    }

    public ClusterSyncHistory getClusterSyncHistory() {
        return this.clusterSyncHistory;
    }

    protected ResourceResolver getResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    @Override
    public void cancelSync() {
        this.cancelPreviousBackgroundCheck();
    }

    @Override
    public void sync(BaseTopologyView view, Runnable callback) {
        this.cancelPreviousBackgroundCheck();
        this.syncToken(view, callback);
    }

    protected void syncToken(final BaseTopologyView view, Runnable callback) {
        this.startBackgroundCheck("SyncTokenService-" + view.getLocalClusterSyncTokenId(), new AbstractServiceWithBackgroundCheck.BackgroundCheck(){

            @Override
            public boolean check() {
                String localClusterSyncTokenId = view.getLocalClusterSyncTokenId();
                if (!SyncTokenService.this.storeMySyncToken(localClusterSyncTokenId)) {
                    SyncTokenService.this.clusterSyncHistory.addHistoryEntry(view, "storing my syncToken (" + localClusterSyncTokenId + ")");
                    return false;
                }
                return SyncTokenService.this.seenAllSyncTokens(view);
            }
        }, callback, this.commonsConfig.getClusterSyncServiceTimeoutMillis(), this.commonsConfig.getClusterSyncServiceIntervalMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeMySyncToken(String syncTokenId) {
        this.logger.trace("storeMySyncToken: start");
        if (this.slingId == null) {
            this.logger.info("storeMySyncToken: not yet activated (slingId is null)");
            return false;
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            Resource resource = ResourceHelper.getOrCreateResource(resourceResolver, this.getSyncTokenPath());
            ModifiableValueMap syncTokens = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            boolean updateToken = false;
            if (!syncTokens.containsKey((Object)this.slingId)) {
                updateToken = true;
            } else {
                Object existingToken = syncTokens.get((Object)this.slingId);
                if (existingToken == null || !existingToken.equals(syncTokenId)) {
                    updateToken = true;
                }
            }
            if (updateToken) {
                syncTokens.put((Object)this.slingId, (Object)syncTokenId);
                resourceResolver.commit();
                this.logSilencer.infoOrDebug("storeMySyncToken-" + syncTokenId, "storeMySyncToken: stored syncToken of slingId=" + this.slingId + " as=" + syncTokenId);
            } else {
                this.logSilencer.infoOrDebug("storeMySyncToken-" + syncTokenId, "storeMySyncToken: syncToken was left unchanged for slingId=" + this.slingId + " at=" + syncTokenId);
            }
            boolean bl = true;
            return bl;
        }
        catch (LoginException e) {
            this.logger.error("storeMySyncToken: could not login for storing my syncToken: " + String.valueOf((Object)e), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (PersistenceException e) {
            this.logger.error("storeMySyncToken: got PersistenceException while storing my syncToken (my slingId=" + this.slingId + ", syncToken=" + syncTokenId + "): " + String.valueOf((Object)e), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.trace("storeMySyncToken: end");
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private String getSyncTokenPath() {
        return this.commonsConfig.getSyncTokenPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean seenAllSyncTokens(BaseTopologyView view) {
        this.logger.trace("seenAllSyncTokens: start");
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            Resource resource = ResourceHelper.getOrCreateResource(resourceResolver, this.getSyncTokenPath());
            ValueMap syncTokens = (ValueMap)resource.adaptTo(ValueMap.class);
            String syncToken = view.getLocalClusterSyncTokenId();
            boolean success = true;
            StringBuffer historyEntry = new StringBuffer();
            for (InstanceDescription instance : view.getLocalInstance().getClusterView().getInstances()) {
                String msg;
                String instanceSlingId = instance.getSlingId();
                Object currentValue = syncTokens.get((Object)instanceSlingId);
                if (currentValue == null) {
                    msg = "no syncToken yet of " + instance.getSlingId();
                    this.logSilencer.infoOrDebug("seenAllSyncToken-" + syncToken + "-no-" + instanceSlingId, "seenAllSyncTokens: " + msg);
                    if (historyEntry.length() != 0) {
                        historyEntry.append(",");
                    }
                    historyEntry.append(msg);
                    success = false;
                    continue;
                }
                if (syncToken.equals(currentValue)) continue;
                msg = "syncToken of " + instance.getSlingId() + " is " + String.valueOf(currentValue) + " waiting for " + syncToken;
                this.logSilencer.infoOrDebug("seenAllSyncToken-" + syncToken + "-wait-" + instanceSlingId, "seenAllSyncTokens: " + msg);
                if (historyEntry.length() != 0) {
                    historyEntry.append(",");
                }
                historyEntry.append(msg);
                success = false;
            }
            if (!success) {
                this.logSilencer.infoOrDebug("seenAllSyncToken-result-" + syncToken, "seenAllSyncTokens: not yet seen all expected syncTokens (see above for details)");
                this.clusterSyncHistory.addHistoryEntry(view, historyEntry.toString());
                boolean bl = false;
                return bl;
            }
            this.clusterSyncHistory.addHistoryEntry(view, "seen all syncTokens");
            resourceResolver.commit();
            this.logSilencer.infoOrDebug("seenAllSyncToken-result-" + syncToken, "seenAllSyncTokens: seen all syncTokens!");
            boolean bl = true;
            return bl;
        }
        catch (LoginException e) {
            this.logger.error("seenAllSyncTokens: could not login: " + String.valueOf((Object)e), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (PersistenceException e) {
            this.logger.error("seenAllSyncTokens: got PersistenceException: " + String.valueOf((Object)e), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.trace("seenAllSyncTokens: end");
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }
}

