/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.LoggerFactory;

@Component(service={}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class LogReporter
implements ServiceTrackerCustomizer<MetricRegistry, Slf4jReporter> {
    private BundleContext context;
    private ServiceTracker<MetricRegistry, Slf4jReporter> tracker;
    private Config config;

    @Activate
    protected void activate(Config config, BundleContext context) {
        this.config = config;
        this.context = context;
        this.tracker = new ServiceTracker(context, MetricRegistry.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    @Deactivate
    protected void deactivate(BundleContext context) {
        this.tracker.close();
    }

    public Slf4jReporter addingService(ServiceReference<MetricRegistry> serviceReference) {
        MetricRegistry registry = (MetricRegistry)this.context.getService(serviceReference);
        String metricRegistryName = (String)serviceReference.getProperty("name");
        if (this.config.registryName() == null || this.config.registryName().length() == 0 || this.config.registryName().equals(metricRegistryName)) {
            Slf4jReporter.Builder builder = Slf4jReporter.forRegistry((MetricRegistry)registry).outputTo(LoggerFactory.getLogger((String)this.config.loggerName())).withLoggingLevel(this.config.level());
            if (this.config.prefix() != null && this.config.prefix().length() > 0) {
                builder.filter((MetricFilter)new PrefixFilter(this.config.prefix()));
            } else if (this.config.pattern() != null && this.config.pattern().length() > 0) {
                builder.filter((MetricFilter)new PatternFilter(this.config.pattern()));
            }
            Slf4jReporter reporter = builder.build();
            reporter.start(this.config.period(), this.config.timeUnit());
            return reporter;
        }
        return null;
    }

    public void modifiedService(ServiceReference<MetricRegistry> serviceReference, Slf4jReporter reporter) {
    }

    public void removedService(ServiceReference<MetricRegistry> serviceReference, Slf4jReporter reporter) {
        if (reporter != null) {
            reporter.close();
        }
    }

    @ObjectClassDefinition(name="Apache Sling Metrics Log Reporter Configuration")
    static @interface Config {
        @AttributeDefinition(description="Period at which the metrics data will be logged")
        public long period() default 5L;

        @AttributeDefinition(description="Unit of time for evaluating the period")
        public TimeUnit timeUnit() default TimeUnit.MINUTES;

        @AttributeDefinition(description="The log level to log at.")
        public Slf4jReporter.LoggingLevel level() default Slf4jReporter.LoggingLevel.INFO;

        @AttributeDefinition(description="The logger name")
        public String loggerName() default "metrics";

        @AttributeDefinition(description="If specified, only metrics whose name starts with this value are logged. If both prefix and pattern are set, prefix is used.")
        public String prefix() default "";

        @AttributeDefinition(description="If specified, only metrics whose name matches this regular expression will be logged. If both prefix and pattern are set, prefix is used.")
        public String pattern() default "";

        @AttributeDefinition(description="Restrict the metrics logged to a specifically named registry.")
        public String registryName() default "";
    }

    private class PatternFilter
    implements MetricFilter {
        private final Pattern pattern;

        private PatternFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public boolean matches(String s, Metric metric) {
            return this.pattern.matcher(s).matches();
        }
    }

    private class PrefixFilter
    implements MetricFilter {
        private final String prefix;

        private PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean matches(String s, Metric metric) {
            return s.startsWith(this.prefix);
        }
    }
}

