/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class VersionInfo {
    private static final Logger log = LoggerFactory.getLogger(VersionInfo.class);
    private Resource resource;

    public VersionInfo(Resource resource) {
        this.resource = resource;
    }

    public List<Version> getVersions() {
        ArrayList<Version> versions = new ArrayList<Version>();
        Node node = (Node)this.resource.adaptTo(Node.class);
        try {
            if (node != null && node.isNodeType("mix:versionable")) {
                VersionHistory history = node.getSession().getWorkspace().getVersionManager().getVersionHistory(node.getPath());
                VersionIterator it = history.getAllVersions();
                while (it.hasNext()) {
                    Version v = it.nextVersion();
                    versions.add(v);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Exception retrieving version history for: " + this.resource, (Throwable)e);
        }
        return versions;
    }
}

