/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.Component;
import org.apache.sling.cms.ComponentManager;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={ResourceResolver.class}, adapters={ComponentManager.class})
public class ComponentManagerImpl
implements ComponentManager {
    private ResourceResolver resolver;
    private Map<String, List<Component>> componentCache = null;

    public ComponentManagerImpl(Resource resource) {
        this.resolver = resource.getResourceResolver();
    }

    public ComponentManagerImpl(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public List<Component> getAllComponents() {
        HashSet<Component> allComponents = new HashSet<Component>();
        if (this.componentCache == null) {
            this.loadComponents();
        }
        for (List<Component> components : this.componentCache.values()) {
            allComponents.addAll(components);
        }
        return new ArrayList<Component>(allComponents);
    }

    public Map<String, List<Component>> getComponentsByType() {
        if (this.componentCache == null) {
            this.loadComponents();
        }
        return this.componentCache;
    }

    public List<String> getComponentTypes() {
        if (this.componentCache == null) {
            this.loadComponents();
        }
        ArrayList<String> types = new ArrayList<String>(this.componentCache.keySet());
        Collections.sort(types);
        return types;
    }

    private void loadComponents() {
        Iterator components = this.resolver.findResources("SELECT * FROM [sling:Component] WHERE [componentType] IS NOT NULL", "JCR-SQL2");
        this.componentCache = new HashMap<String, List<Component>>();
        while (components.hasNext()) {
            Resource cmpRsrc = (Resource)components.next();
            Component component = (Component)cmpRsrc.adaptTo(Component.class);
            if (component == null) continue;
            for (String type : component.getComponentType()) {
                this.componentCache.putIfAbsent(type, new ArrayList());
                this.componentCache.get(type).add(component);
            }
        }
    }
}

