/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.clickhouse;

import java.sql.SQLException;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class ClickHouseStatementTracingWrapper {
    public static <T> T of(ConnectionInfo connectionInfo, String methodName, String sql, SupplierWithException<T> supplier) throws SQLException {
        AbstractSpan span = ContextManager.createExitSpan((String)(connectionInfo.getDBType() + "/JDBC/Statement/" + methodName), (String)connectionInfo.getDatabasePeer());
        try {
            Tags.DB_TYPE.set(span, connectionInfo.getDBType());
            Tags.DB_INSTANCE.set(span, connectionInfo.getDatabaseName());
            Tags.DB_STATEMENT.set(span, sql);
            span.setComponent((Component)connectionInfo.getComponent());
            SpanLayer.asDB((AbstractSpan)span);
            T t = supplier.get();
            return t;
        }
        catch (SQLException e) {
            span.log((Throwable)e);
            throw e;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public static interface SupplierWithException<T> {
        public T get() throws SQLException;
    }
}

