/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.solon;

import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.solon.SolonPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonActionExecuteInterceptor
implements InstanceMethodsAroundInterceptorV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolonActionExecuteInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        String body;
        Context ctx = (Context)allArguments[0];
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(ctx.header(next.getHeadKey()));
        }
        String operationName = ctx.method() + ":" + ctx.path();
        AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.SOLON_MVC);
        SpanLayer.asHttp((AbstractSpan)span);
        Tags.URL.set(span, ctx.url());
        Tags.HTTP.METHOD.set(span, ctx.method());
        if (SolonPluginConfig.Plugin.Solon.INCLUDE_HTTP_HEADERS != null && !SolonPluginConfig.Plugin.Solon.INCLUDE_HTTP_HEADERS.isEmpty()) {
            NvMap includeHeaders = new NvMap();
            for (String header : SolonPluginConfig.Plugin.Solon.INCLUDE_HTTP_HEADERS) {
                String value = ctx.header(header);
                if (!StringUtil.isNotBlank((String)value)) continue;
                includeHeaders.put(header, (Object)value);
            }
            Tags.HTTP.HEADERS.set(span, includeHeaders.toString());
        }
        if (SolonPluginConfig.Plugin.Solon.HTTP_BODY_LENGTH_THRESHOLD != 0 && StringUtil.isNotBlank((String)(body = ctx.body()))) {
            if (SolonPluginConfig.Plugin.Solon.HTTP_BODY_LENGTH_THRESHOLD > 0 && body.length() > SolonPluginConfig.Plugin.Solon.HTTP_BODY_LENGTH_THRESHOLD) {
                body = body.substring(0, SolonPluginConfig.Plugin.Solon.HTTP_BODY_LENGTH_THRESHOLD);
            }
            Tags.HTTP.BODY.set(span, body);
        }
        if (SolonPluginConfig.Plugin.Solon.HTTP_PARAMS_LENGTH_THRESHOLD != 0) {
            String param = ctx.paramMap().toString();
            if (SolonPluginConfig.Plugin.Solon.HTTP_PARAMS_LENGTH_THRESHOLD > 0 && param.length() > SolonPluginConfig.Plugin.Solon.HTTP_PARAMS_LENGTH_THRESHOLD) {
                param = param.substring(0, SolonPluginConfig.Plugin.Solon.HTTP_PARAMS_LENGTH_THRESHOLD);
            }
            Tags.HTTP.PARAMS.set(span, param);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) {
        Context ctx = (Context)allArguments[0];
        Tags.HTTP_RESPONSE_STATUS_CODE.set(ContextManager.activeSpan(), Integer.valueOf(ctx.status()));
        if (ctx.errors != null && context.getContext() == null) {
            AbstractSpan activeSpan = ContextManager.activeSpan();
            activeSpan.errorOccurred();
            activeSpan.log(ctx.errors);
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.errorOccurred();
        activeSpan.log(t);
        context.setContext((Object)true);
    }
}

