/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.ttl;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.ttl.MetricsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.RecordsTTL;

public class TTLDefinition {
    private final MetricsTTL metrics;
    private final RecordsTTL records;

    public String toString() {
        StringBuilder ttlDefinition = new StringBuilder();
        ttlDefinition.append("# Metrics TTL includes the definition of the TTL of the metrics-ish data in the storage,\n");
        ttlDefinition.append("# e.g.\n");
        ttlDefinition.append("# 1. The metadata of the service, instance, endpoint, topology map, etc.\n");
        ttlDefinition.append("# 2. Generated metrics data from OAL and MAL engines.\n");
        ttlDefinition.append("# 3. Banyandb storage provides Data Lifecycle Stages(Hot/Warm/Cold).\n");
        ttlDefinition.append("#\n");
        ttlDefinition.append("# TTLs for each granularity metrics are listed separately.\n");
        ttlDefinition.append("#\n");
        ttlDefinition.append("# Cover hot and warm data for BanyanDB.\n");
        ttlDefinition.append("metrics.minute=").append(this.metrics.getMinute()).append("\n");
        ttlDefinition.append("metrics.hour=").append(this.metrics.getHour()).append("\n");
        ttlDefinition.append("metrics.day=").append(this.metrics.getDay()).append("\n");
        ttlDefinition.append("# Cold data, '-1' represents no cold stage data.\n");
        ttlDefinition.append("metrics.minute.cold=").append(this.metrics.getColdMinute()).append("\n");
        ttlDefinition.append("metrics.hour.cold=").append(this.metrics.getColdHour()).append("\n");
        ttlDefinition.append("metrics.day.cold=").append(this.metrics.getColdDay()).append("\n");
        ttlDefinition.append("\n");
        ttlDefinition.append("# Records TTL includes the definition of the TTL of the records data in the storage,\n");
        ttlDefinition.append("# Records include traces, logs, sampled slow SQL statements, HTTP requests(by Rover), alarms, etc.\n");
        ttlDefinition.append("# Super dataset of records are traces and logs, which volume should be much larger.\n");
        ttlDefinition.append("#\n");
        ttlDefinition.append("# Cover hot and warm data for BanyanDB.\n");
        ttlDefinition.append("records.normal=").append(this.records.getNormal()).append("\n");
        ttlDefinition.append("records.trace=").append(this.records.getTrace()).append("\n");
        ttlDefinition.append("records.zipkinTrace=").append(this.records.getZipkinTrace()).append("\n");
        ttlDefinition.append("records.log=").append(this.records.getLog()).append("\n");
        ttlDefinition.append("records.browserErrorLog=").append(this.records.getBrowserErrorLog()).append("\n");
        ttlDefinition.append("# Cold data, '-1' represents no cold stage data.\n");
        ttlDefinition.append("records.normal.cold=").append(this.records.getColdNormal()).append("\n");
        ttlDefinition.append("records.trace.cold=").append(this.records.getColdTrace()).append("\n");
        ttlDefinition.append("records.zipkinTrace.cold=").append(this.records.getColdZipkinTrace()).append("\n");
        ttlDefinition.append("records.log.cold=").append(this.records.getColdLog()).append("\n");
        ttlDefinition.append("records.browserErrorLog.cold=").append(this.records.getColdBrowserErrorLog()).append("\n");
        return ttlDefinition.toString();
    }

    @Generated
    public TTLDefinition(MetricsTTL metrics, RecordsTTL records) {
        this.metrics = metrics;
        this.records = records;
    }

    @Generated
    public MetricsTTL getMetrics() {
        return this.metrics;
    }

    @Generated
    public RecordsTTL getRecords() {
        return this.records;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TTLDefinition)) {
            return false;
        }
        TTLDefinition other = (TTLDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricsTTL this$metrics = this.getMetrics();
        MetricsTTL other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        RecordsTTL this$records = this.getRecords();
        RecordsTTL other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TTLDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricsTTL $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        RecordsTTL $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }
}

