/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.max;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@MeterFunction(functionName="maxLabeled")
public abstract class MaxLabeledFunction
extends Meter
implements AcceptableValue<DataTable>,
LabeledValueHolder {
    public static final String VALUE = "datatable_value";
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @BanyanDB.MeasureField
    private DataTable value = new DataTable(30);

    @Override
    public void accept(MeterEntity entity, DataTable value) {
        this.setEntityId(entity.id());
        this.setServiceId(entity.serviceId());
        this.value.setMaxValue(value);
    }

    @Override
    public final boolean combine(Metrics metrics) {
        MaxLabeledFunction maxLabeledFunction = (MaxLabeledFunction)metrics;
        this.value.setMaxValue(maxLabeledFunction.getValue());
        return true;
    }

    @Override
    public final void calculate() {
    }

    @Override
    public Metrics toHour() {
        MaxLabeledFunction metrics = (MaxLabeledFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.getValue().copyFrom(this.getValue());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        MaxLabeledFunction metrics = (MaxLabeledFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.getValue().copyFrom(this.getValue());
        return metrics;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setValue(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setServiceId(remoteData.getDataStrings(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataObjectStrings(this.value.toStorageData());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataStrings(this.serviceId);
        return remoteBuilder;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public Class<? extends MaxLabeledStorageBuilder> builder() {
        return MaxLabeledStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaxLabeledFunction)) {
            return false;
        }
        MaxLabeledFunction function = (MaxLabeledFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "MaxLabeledFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public DataTable getValue() {
        return this.value;
    }

    @Generated
    public void setValue(DataTable value) {
        this.value = value;
    }

    public static class MaxLabeledStorageBuilder
    implements StorageBuilder<MaxLabeledFunction> {
        @Override
        public MaxLabeledFunction storage2Entity(Convert2Entity converter) {
            MaxLabeledFunction metrics = new MaxLabeledFunction(){

                @Override
                public AcceptableValue<DataTable> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setValue(new DataTable((String)converter.get(MaxLabeledFunction.VALUE)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(MaxLabeledFunction storageData, Convert2Storage converter) {
            converter.accept(MaxLabeledFunction.VALUE, storageData.getValue());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

