/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContentDisposition;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class ContentDispositionBuilder {
    private final String type;
    @Nullable
    private String name;
    @Nullable
    private String filename;
    @Nullable
    private Charset charset;

    ContentDispositionBuilder(String type) {
        this.type = type;
    }

    public ContentDispositionBuilder name(String name) {
        Objects.requireNonNull(name, "name");
        this.name = name;
        return this;
    }

    public ContentDispositionBuilder filename(String filename) {
        return this.filename(filename, null);
    }

    public ContentDispositionBuilder filename(String filename, @Nullable Charset charset) {
        Objects.requireNonNull(filename, "filename");
        Preconditions.checkArgument(!filename.isEmpty(), "filename should not be empty.");
        this.filename = filename;
        if (charset != null) {
            Preconditions.checkArgument(charset == StandardCharsets.US_ASCII || charset == StandardCharsets.UTF_8 || charset == StandardCharsets.ISO_8859_1, "Charset: %s (expected: US-ASCII, UTF-8 or ISO-8859-1)", (Object)charset);
        }
        this.charset = charset;
        return this;
    }

    public ContentDisposition build() {
        return new ContentDisposition(this.type, this.name, this.filename, this.charset);
    }
}

