/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.BlockingWebClientRequestPreparation;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.DefaultBlockingWebClient;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientUtil;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.Unwrappable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;

@UnstableApi
public interface BlockingWebClient
extends ClientBuilderParams,
Unwrappable {
    @UnstableApi
    public static BlockingWebClient of() {
        return DefaultBlockingWebClient.DEFAULT;
    }

    @UnstableApi
    public static BlockingWebClient of(String uri) {
        return WebClient.of(uri).blocking();
    }

    @UnstableApi
    public static BlockingWebClient of(URI uri) {
        return WebClient.of(uri).blocking();
    }

    default public AggregatedHttpResponse execute(HttpRequest req) {
        return this.execute(req, RequestOptions.of());
    }

    public AggregatedHttpResponse execute(HttpRequest var1, RequestOptions var2);

    default public AggregatedHttpResponse execute(AggregatedHttpRequest aggregatedReq) {
        Objects.requireNonNull(aggregatedReq, "aggregatedReq");
        return this.execute(aggregatedReq.toHttpRequest());
    }

    default public AggregatedHttpResponse execute(RequestHeaders headers) {
        return this.execute(HttpRequest.of(headers));
    }

    default public AggregatedHttpResponse execute(RequestHeaders headers, HttpData content) {
        return this.execute(HttpRequest.of(headers, content));
    }

    default public AggregatedHttpResponse execute(RequestHeaders headers, byte[] content) {
        return this.execute(HttpRequest.of(headers, HttpData.wrap(content)));
    }

    default public AggregatedHttpResponse execute(RequestHeaders headers, String content) {
        return this.execute(HttpRequest.of(headers, HttpData.ofUtf8(content)));
    }

    default public AggregatedHttpResponse execute(RequestHeaders headers, String content, Charset charset) {
        return this.execute(HttpRequest.of(headers, HttpData.of(charset, content)));
    }

    public BlockingWebClientRequestPreparation prepare();

    default public AggregatedHttpResponse options(String path) {
        return this.options(path, null);
    }

    default public AggregatedHttpResponse options(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.OPTIONS, WebClientUtil.addQueryParams(path, params)));
    }

    default public AggregatedHttpResponse get(String path) {
        return this.get(path, null);
    }

    default public AggregatedHttpResponse get(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.GET, WebClientUtil.addQueryParams(path, params)));
    }

    default public AggregatedHttpResponse head(String path) {
        return this.head(path, null);
    }

    default public AggregatedHttpResponse head(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.HEAD, WebClientUtil.addQueryParams(path, params)));
    }

    default public AggregatedHttpResponse post(String path, HttpData content) {
        return this.post(path, null, content);
    }

    default public AggregatedHttpResponse post(String path, @Nullable QueryParams params, HttpData content) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse post(String path, byte[] content) {
        return this.post(path, null, content);
    }

    default public AggregatedHttpResponse post(String path, @Nullable QueryParams params, byte[] content) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse post(String path, String content) {
        return this.post(path, null, content);
    }

    default public AggregatedHttpResponse post(String path, @Nullable QueryParams params, String content) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse post(String path, String content, Charset charset) {
        return this.post(path, null, content, charset);
    }

    default public AggregatedHttpResponse post(String path, @Nullable QueryParams params, String content, Charset charset) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content, charset);
    }

    default public AggregatedHttpResponse put(String path, HttpData content) {
        return this.put(path, null, content);
    }

    default public AggregatedHttpResponse put(String path, @Nullable QueryParams params, HttpData content) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse put(String path, byte[] content) {
        return this.put(path, null, content);
    }

    default public AggregatedHttpResponse put(String path, @Nullable QueryParams params, byte[] content) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse put(String path, String content) {
        return this.put(path, null, content);
    }

    default public AggregatedHttpResponse put(String path, @Nullable QueryParams params, String content) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse put(String path, String content, Charset charset) {
        return this.put(path, null, content, charset);
    }

    default public AggregatedHttpResponse put(String path, @Nullable QueryParams params, String content, Charset charset) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content, charset);
    }

    default public AggregatedHttpResponse patch(String path, HttpData content) {
        return this.patch(path, null, content);
    }

    default public AggregatedHttpResponse patch(String path, @Nullable QueryParams params, HttpData content) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse patch(String path, byte[] content) {
        return this.patch(path, null, content);
    }

    default public AggregatedHttpResponse patch(String path, @Nullable QueryParams params, byte[] content) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse patch(String path, String content) {
        return this.patch(path, null, content);
    }

    default public AggregatedHttpResponse patch(String path, @Nullable QueryParams params, String content) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content);
    }

    default public AggregatedHttpResponse patch(String path, String content, Charset charset) {
        return this.patch(path, null, content, charset);
    }

    default public AggregatedHttpResponse patch(String path, @Nullable QueryParams params, String content, Charset charset) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content, charset);
    }

    default public AggregatedHttpResponse delete(String path) {
        return this.delete(path, null);
    }

    default public AggregatedHttpResponse delete(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.DELETE, WebClientUtil.addQueryParams(path, params)));
    }

    default public AggregatedHttpResponse trace(String path) {
        return this.trace(path, null);
    }

    default public AggregatedHttpResponse trace(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.TRACE, WebClientUtil.addQueryParams(path, params)));
    }

    @Override
    public HttpClient unwrap();
}

