/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc.exception;

import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBApiExceptionFactory;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;

public class BanyanDBGrpcApiExceptionFactory {
    private final ImmutableSet<Status.Code> retryableCodes;

    public BanyanDBGrpcApiExceptionFactory(Set<Status.Code> retryCodes) {
        this.retryableCodes = ImmutableSet.copyOf(retryCodes);
    }

    public BanyanDBException createException(Throwable throwable) {
        if (throwable instanceof StatusException) {
            StatusException e = (StatusException)throwable;
            return this.create(throwable, e.getStatus().getCode());
        }
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException e = (StatusRuntimeException)throwable;
            return this.create(throwable, e.getStatus().getCode());
        }
        if (throwable instanceof BanyanDBException) {
            return (BanyanDBException)throwable;
        }
        return BanyanDBApiExceptionFactory.createException(throwable, Status.Code.UNKNOWN, false);
    }

    private BanyanDBException create(Throwable throwable, Status.Code statusCode) {
        boolean retryable = this.retryableCodes.contains((Object)statusCode);
        return BanyanDBApiExceptionFactory.createException(throwable, statusCode, retryable);
    }
}

