/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import java.util.List;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;

public abstract class PairQueryCondition<T>
extends AbstractCriteria {
    protected final BanyandbModel.Condition.BinaryOp op;
    private final TagAndValue<T> tagAndValue;
    private final BanyandbModel.Condition.MatchOption matchOption;

    private PairQueryCondition(BanyandbModel.Condition.BinaryOp op, TagAndValue<T> tagAndValue) {
        this.op = op;
        this.tagAndValue = tagAndValue;
        this.matchOption = BanyandbModel.Condition.MatchOption.getDefaultInstance();
    }

    private PairQueryCondition(BanyandbModel.Condition.BinaryOp op, TagAndValue<T> tagAndValue, BanyandbModel.Condition.MatchOption matchOption) {
        this.op = op;
        this.tagAndValue = tagAndValue;
        this.matchOption = matchOption;
    }

    @Override
    public BanyandbModel.Criteria build() {
        BanyandbModel.Condition.Builder condition = BanyandbModel.Condition.newBuilder().setName(this.tagAndValue.getTagName()).setOp(this.op).setValue(this.tagAndValue.buildTypedTagValue());
        if (this.matchOption != null) {
            condition.setMatchOption(this.matchOption);
        }
        return BanyandbModel.Criteria.newBuilder().setCondition(condition.build()).build();
    }

    public String getTagName() {
        return this.tagAndValue.getTagName();
    }

    public static class LongArrayQueryCondition
    extends PairQueryCondition<List<Long>> {
        private LongArrayQueryCondition(String tagName, BanyandbModel.Condition.BinaryOp op, List<Long> value) {
            super(op, (TagAndValue)new TagAndValue.LongArrayTagPair(tagName, value));
        }

        public static PairQueryCondition<List<Long>> eq(String tagName, List<Long> val) {
            return new LongArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_EQ, val);
        }

        public static PairQueryCondition<List<Long>> ne(String tagName, List<Long> val) {
            return new LongArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NE, val);
        }

        public static PairQueryCondition<List<Long>> having(String tagName, List<Long> val) {
            return new LongArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_HAVING, val);
        }

        public static PairQueryCondition<List<Long>> notHaving(String tagName, List<Long> val) {
            return new LongArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NOT_HAVING, val);
        }
    }

    public static class StringArrayQueryCondition
    extends PairQueryCondition<List<String>> {
        private StringArrayQueryCondition(String tagName, BanyandbModel.Condition.BinaryOp op, List<String> value) {
            super(op, (TagAndValue)new TagAndValue.StringArrayTagPair(tagName, value));
        }

        public static PairQueryCondition<List<String>> eq(String tagName, List<String> val) {
            return new StringArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_EQ, val);
        }

        public static PairQueryCondition<List<String>> ne(String tagName, List<String> val) {
            return new StringArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NE, val);
        }

        public static PairQueryCondition<List<String>> having(String tagName, List<String> val) {
            return new StringArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_HAVING, val);
        }

        public static PairQueryCondition<List<String>> notHaving(String tagName, List<String> val) {
            return new StringArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NOT_HAVING, val);
        }

        public static PairQueryCondition<List<String>> in(String tagName, List<String> val) {
            return new StringArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_IN, val);
        }

        public static PairQueryCondition<List<String>> notIn(String tagName, List<String> val) {
            return new StringArrayQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NOT_IN, val);
        }
    }

    public static class StringQueryCondition
    extends PairQueryCondition<String> {
        private StringQueryCondition(String tagName, BanyandbModel.Condition.BinaryOp op, String value) {
            super(op, (TagAndValue)new TagAndValue.StringTagPair(tagName, value));
        }

        private StringQueryCondition(String tagName, BanyandbModel.Condition.BinaryOp op, String value, BanyandbModel.Condition.MatchOption matchOption) {
            super(op, new TagAndValue.StringTagPair(tagName, value), matchOption);
        }

        public static PairQueryCondition<String> eq(String tagName, String val) {
            return new StringQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_EQ, val);
        }

        public static PairQueryCondition<String> ne(String tagName, String val) {
            return new StringQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NE, val);
        }

        public static PairQueryCondition<String> match(String tagName, String val) {
            return new StringQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_MATCH, val);
        }

        public static PairQueryCondition<String> match(String tagName, String val, BanyandbModel.Condition.MatchOption matchOption) {
            return new StringQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_MATCH, val, matchOption);
        }
    }

    public static class LongQueryCondition
    extends PairQueryCondition<Long> {
        private LongQueryCondition(String tagName, BanyandbModel.Condition.BinaryOp op, Long value) {
            super(op, (TagAndValue)new TagAndValue.LongTagPair(tagName, value));
        }

        public static PairQueryCondition<Long> eq(String tagName, Long val) {
            return new LongQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_EQ, val);
        }

        public static PairQueryCondition<Long> ne(String tagName, Long val) {
            return new LongQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_NE, val);
        }

        public static PairQueryCondition<Long> gt(String tagName, Long val) {
            return new LongQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_GT, val);
        }

        public static PairQueryCondition<Long> ge(String tagName, Long val) {
            return new LongQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_GE, val);
        }

        public static PairQueryCondition<Long> lt(String tagName, Long val) {
            return new LongQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_LT, val);
        }

        public static PairQueryCondition<Long> le(String tagName, Long val) {
            return new LongQueryCondition(tagName, BanyandbModel.Condition.BinaryOp.BINARY_OP_LE, val);
        }
    }
}

