/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.aws.firehose;

import com.linecorp.armeria.common.HttpMethod;
import java.util.Collections;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;
import org.apache.skywalking.oap.server.receiver.aws.firehose.AWSFirehoseReceiverModule;
import org.apache.skywalking.oap.server.receiver.aws.firehose.AWSFirehoseReceiverModuleConfig;
import org.apache.skywalking.oap.server.receiver.aws.firehose.FirehoseHTTPHandler;
import org.apache.skywalking.oap.server.receiver.otel.otlp.OpenTelemetryMetricRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSFirehoseReceiverModuleProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSFirehoseReceiverModuleProvider.class);
    public static final String NAME = "default";
    private AWSFirehoseReceiverModuleConfig moduleConfig;
    private HTTPServer httpServer;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return AWSFirehoseReceiverModule.class;
    }

    public ModuleProvider.ConfigCreator<AWSFirehoseReceiverModuleConfig> newConfigCreator() {
        return new ModuleProvider.ConfigCreator<AWSFirehoseReceiverModuleConfig>(){

            public Class<AWSFirehoseReceiverModuleConfig> type() {
                return AWSFirehoseReceiverModuleConfig.class;
            }

            public void onInitialized(AWSFirehoseReceiverModuleConfig initialized) {
                AWSFirehoseReceiverModuleProvider.this.moduleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException {
        HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.moduleConfig.getHost()).port(this.moduleConfig.getPort()).contextPath(this.moduleConfig.getContextPath()).idleTimeOut(this.moduleConfig.getIdleTimeOut()).acceptQueueSize(this.moduleConfig.getAcceptQueueSize()).maxRequestHeaderSize(this.moduleConfig.getMaxRequestHeaderSize()).acceptProxyRequest(this.moduleConfig.isEnableTLS()).enableTLS(this.moduleConfig.isEnableTLS()).tlsKeyPath(this.moduleConfig.getTlsKeyPath()).tlsCertChainPath(this.moduleConfig.getTlsCertChainPath()).build();
        this.httpServer = new HTTPServer(httpServerConfig);
        this.httpServer.initialize();
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        OpenTelemetryMetricRequestProcessor processor = (OpenTelemetryMetricRequestProcessor)this.getManager().find("receiver-otel").provider().getService(OpenTelemetryMetricRequestProcessor.class);
        this.httpServer.addHandler((Object)new FirehoseHTTPHandler(processor, this.moduleConfig.getFirehoseAccessKey()), Collections.singletonList(HttpMethod.POST));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        if (!RunningMode.isInitMode()) {
            this.httpServer.start();
        }
    }

    public String[] requiredModules() {
        return new String[]{"receiver-otel"};
    }
}

