/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.protobuf.Value;
import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AbstractALSAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.istio.IstioServiceEntryRegistry;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.Addresses;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.K8SServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sALSServiceMeshHTTPAnalysis
extends AbstractALSAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sALSServiceMeshHTTPAnalysis.class);
    protected K8SServiceRegistry k8sServiceRegistry;
    protected IstioServiceEntryRegistry istioServiceRegistry;
    protected EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "k8s-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.k8sServiceRegistry = new K8SServiceRegistry(config);
        this.istioServiceRegistry = new IstioServiceEntryRegistry(config);
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result result, StreamAccessLogsMessage.Identifier identifier, HTTPAccessLogEntry entry, Role role) {
        switch (role) {
            case PROXY: {
                return this.analyzeProxy(result, entry);
            }
            case SIDECAR: {
                if (result.hasResult()) {
                    return result;
                }
                return this.analyzeSideCar(result, entry);
            }
            case WAYPOINT: {
                return this.analyzeWaypoint(result, identifier, entry);
            }
            case NONE: {
                return result;
            }
        }
        return AccessLogAnalyzer.Result.builder().build();
    }

    protected AccessLogAnalyzer.Result analyzeSideCar(AccessLogAnalyzer.Result previousResult, HTTPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        AccessLogCommon properties = entry.getCommonProperties();
        String cluster = properties.getUpstreamCluster();
        if (StringUtil.isBlank((String)cluster)) {
            return previousResult;
        }
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        ServiceMetaInfo downstreamService = this.find(Addresses.getAddressIP(downstreamRemoteAddress));
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        if (!Addresses.isValid(downstreamRemoteAddress) || !Addresses.isValid(downstreamLocalAddress)) {
            return previousResult;
        }
        ServiceMetaInfo localService = this.find(Addresses.getAddressIP(downstreamLocalAddress));
        AccessLogAnalyzer.Result.ResultBuilder result = AccessLogAnalyzer.Result.builder();
        ServiceMeshMetrics.Builder previousMetrics = previousResult.getMetrics();
        HTTPServiceMeshMetrics.Builder sources = previousMetrics.getHttpMetricsBuilder();
        if (cluster.startsWith("inbound|")) {
            HTTPServiceMeshMetric.Builder metrics;
            if (downstreamService.equals(this.config.serviceMetaInfoFactory().unknown())) {
                metrics = this.newAdapter(entry, null, localService).adaptToDownstreamMetrics();
                log.debug("Transformed ingress->sidecar inbound mesh metrics {}", (Object)metrics);
            } else {
                metrics = this.newAdapter(entry, downstreamService, localService).adaptToDownstreamMetrics();
                log.debug("Transformed sidecar->sidecar(server side) inbound mesh metrics {}", (Object)metrics);
            }
            sources.addMetrics(metrics);
            result.hasDownstreamMetrics(true);
        } else if (cluster.startsWith("outbound|")) {
            Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
            if (!Addresses.isValid(upstreamRemoteAddress)) {
                return result.metrics(ServiceMeshMetrics.newBuilder().setHttpMetrics(sources)).service(localService).build();
            }
            ServiceMetaInfo destService = this.find(Addresses.getAddressIP(upstreamRemoteAddress));
            HTTPServiceMeshMetric.Builder metric = this.newAdapter(entry, downstreamService, destService).adaptToUpstreamMetrics();
            log.debug("Transformed sidecar->sidecar(server side) inbound mesh metric {}", (Object)metric);
            sources.addMetrics(metric);
            result.hasUpstreamMetrics(true);
        }
        return result.metrics(previousMetrics.setHttpMetrics(sources)).service(localService).build();
    }

    protected AccessLogAnalyzer.Result analyzeProxy(AccessLogAnalyzer.Result previousResult, HTTPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        if (previousResult.hasUpstreamMetrics() && previousResult.hasDownstreamMetrics()) {
            return previousResult;
        }
        AccessLogCommon properties = entry.getCommonProperties();
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (!(Addresses.isValid(downstreamLocalAddress) && Addresses.isValid(downstreamRemoteAddress) && Addresses.isValid(upstreamRemoteAddress))) {
            return previousResult;
        }
        return this.buildUpstreamDownstreamMetrics(previousResult, entry, Addresses.getAddressIP(downstreamRemoteAddress), Addresses.getAddressIP(downstreamLocalAddress), Addresses.getAddressIP(upstreamRemoteAddress), "NONE");
    }

    protected AccessLogAnalyzer.Result analyzeWaypoint(AccessLogAnalyzer.Result previousResult, StreamAccessLogsMessage.Identifier identifier, HTTPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        if (previousResult.hasUpstreamMetrics() && previousResult.hasDownstreamMetrics()) {
            return previousResult;
        }
        String waypointIP = this.getWaypointIP(identifier);
        AccessLogCommon properties = entry.getCommonProperties();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() && Addresses.isValid(properties.getDownstreamDirectRemoteAddress()) ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (!Addresses.isValid(downstreamRemoteAddress) || !Addresses.isValid(upstreamRemoteAddress)) {
            return previousResult;
        }
        return this.buildUpstreamDownstreamMetrics(previousResult, entry, Addresses.getAddressIP(downstreamRemoteAddress), waypointIP, Addresses.getAddressIP(upstreamRemoteAddress), null);
    }

    protected String getWaypointIP(StreamAccessLogsMessage.Identifier identifier) {
        String[] split;
        Value instanceIps = (Value)identifier.getNode().getMetadata().getFieldsMap().get("INSTANCE_IPS");
        if (instanceIps != null && instanceIps.hasStringValue() && (split = instanceIps.getStringValue().split(":", 2)).length == 2) {
            return split[0];
        }
        String nodeId = identifier.getNode().getId();
        String[] nodeInfo = nodeId.split("~", 3);
        if (nodeInfo.length != 3) {
            return null;
        }
        return nodeInfo[1];
    }

    protected AccessLogAnalyzer.Result buildUpstreamDownstreamMetrics(AccessLogAnalyzer.Result previousResult, HTTPAccessLogEntry entry, String downStreamRemoteAddr, String downStreamLocalAddr, String upstreamRemoteAddr, String upstreamMetricsTLS) {
        if (StringUtil.isEmpty((String)downStreamRemoteAddr) || StringUtil.isEmpty((String)downStreamLocalAddr) || StringUtil.isEmpty((String)upstreamRemoteAddr)) {
            return previousResult;
        }
        ServiceMetaInfo ingress = this.find(downStreamLocalAddr);
        AccessLogAnalyzer.Result.ResultBuilder newResult = previousResult.toBuilder();
        ServiceMeshMetrics.Builder previousMetrics = previousResult.getMetrics();
        HTTPServiceMeshMetrics.Builder previousHttpMetrics = previousMetrics.getHttpMetricsBuilder();
        if (!previousResult.hasDownstreamMetrics()) {
            ServiceMetaInfo outside = this.find(downStreamRemoteAddr);
            HTTPServiceMeshMetric.Builder metric = this.newAdapter(entry, outside, ingress).adaptToDownstreamMetrics();
            log.debug("Transformed ingress inbound mesh metric {}", (Object)metric);
            previousHttpMetrics.addMetrics(metric);
            newResult.hasDownstreamMetrics(true);
        }
        if (!previousResult.hasUpstreamMetrics()) {
            ServiceMetaInfo targetService = this.find(upstreamRemoteAddr);
            HTTPServiceMeshMetric.Builder outboundMetric = this.newAdapter(entry, ingress, targetService).adaptToUpstreamMetrics();
            if (StringUtil.isNotEmpty((String)upstreamMetricsTLS)) {
                outboundMetric = outboundMetric.setTlsMode("NONE");
            }
            log.debug("Transformed ingress outbound mesh metric {}", (Object)outboundMetric);
            previousHttpMetrics.addMetrics(outboundMetric);
            newResult.hasUpstreamMetrics(true);
        }
        return newResult.metrics(previousMetrics.setHttpMetrics(previousHttpMetrics)).service(ingress).build();
    }

    protected ServiceMetaInfo find(String ip) {
        ServiceMetaInfo istioService = this.istioServiceRegistry.findService(ip);
        if (!Objects.equals(this.config.serviceMetaInfoFactory().unknown(), istioService)) {
            return istioService;
        }
        return this.k8sServiceRegistry.findService(ip);
    }
}

