/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.starter.config;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ProviderNotFoundException;
import org.apache.skywalking.oap.server.library.module.TerminalFriendlyTable;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.PropertyPlaceholderHelper;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.YamlConfigLoaderUtils;
import org.apache.skywalking.oap.server.starter.config.ConfigFileNotFoundException;
import org.apache.skywalking.oap.server.starter.config.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ApplicationConfigLoader
implements ConfigLoader<ApplicationConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigLoader.class);
    private static final String DISABLE_SELECTOR = "-";
    private static final String SELECTOR = "selector";
    private final TerminalFriendlyTable bootingParameters;
    private final Yaml yaml;
    private final List<ApplicationConfiguration.ModuleConfiguration> resolvedConfigurations;

    public ApplicationConfigLoader(TerminalFriendlyTable bootingParameters) {
        this.bootingParameters = bootingParameters;
        this.yaml = new Yaml();
        this.resolvedConfigurations = new ArrayList<ApplicationConfiguration.ModuleConfiguration>();
    }

    @Override
    public ApplicationConfiguration load() throws ConfigFileNotFoundException {
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        this.loadConfig(configuration);
        this.overrideConfigBySystemEnv(configuration);
        return configuration;
    }

    private void loadConfig(ApplicationConfiguration configuration) throws ConfigFileNotFoundException {
        try {
            Reader applicationReader = ResourceUtils.read((String)"application.yml");
            Map moduleConfig = (Map)this.yaml.loadAs(applicationReader, Map.class);
            if (CollectionUtils.isNotEmpty((Map)moduleConfig)) {
                this.selectConfig(moduleConfig);
                moduleConfig.forEach((moduleName, providerConfig) -> {
                    if (providerConfig.size() > 0) {
                        log.info("Get a module define from application.yml, module name: {}", moduleName);
                        ApplicationConfiguration.ModuleConfiguration moduleConfiguration = configuration.addModule(moduleName);
                        providerConfig.forEach((providerName, config) -> {
                            log.info("Get a provider define belong to {} module, provider name: {}", moduleName, providerName);
                            this.bootingParameters.addRow(new TerminalFriendlyTable.Row("module." + moduleName + ".provider", providerName));
                            Map propertiesConfig = (Map)config;
                            Properties properties = new Properties();
                            if (propertiesConfig != null) {
                                propertiesConfig.forEach((propertyName, propertyValue) -> {
                                    if (propertyValue instanceof Map) {
                                        Properties subProperties = new Properties();
                                        ((Map)propertyValue).forEach((key, value) -> {
                                            subProperties.put(key, value);
                                            YamlConfigLoaderUtils.replacePropertyAndLog((String)key, (Object)value, (Properties)subProperties, (Object)providerName, (Yaml)this.yaml);
                                        });
                                        properties.put(propertyName, subProperties);
                                    } else {
                                        properties.put(propertyName, propertyValue);
                                        YamlConfigLoaderUtils.replacePropertyAndLog((String)propertyName, (Object)propertyValue, (Properties)properties, (Object)providerName, (Yaml)this.yaml);
                                    }
                                });
                            }
                            moduleConfiguration.addProviderConfiguration(providerName, properties);
                            this.resolvedConfigurations.add(moduleConfiguration);
                        });
                    } else {
                        log.warn("Get a module define from application.yml, but no provider define, use default, module name: {}", moduleName);
                    }
                });
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigFileNotFoundException(e.getMessage(), e);
        }
    }

    private void overrideConfigBySystemEnv(ApplicationConfiguration configuration) {
        for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
            this.overrideModuleSettings(configuration, prop.getKey().toString(), prop.getValue().toString());
        }
    }

    private void selectConfig(Map<String, Map<String, Object>> moduleConfiguration) {
        Iterator<Map.Entry<String, Map<String, Object>>> moduleIterator = moduleConfiguration.entrySet().iterator();
        while (moduleIterator.hasNext()) {
            Map.Entry<String, Map<String, Object>> entry = moduleIterator.next();
            String moduleName = entry.getKey();
            Map<String, Object> providerConfig = entry.getValue();
            if (!providerConfig.containsKey(SELECTOR)) continue;
            String selector = (String)providerConfig.get(SELECTOR);
            String resolvedSelector = PropertyPlaceholderHelper.INSTANCE.replacePlaceholders(selector, System.getProperties());
            providerConfig.entrySet().removeIf(e -> !resolvedSelector.equals(e.getKey()));
            if (!providerConfig.isEmpty()) continue;
            if (!DISABLE_SELECTOR.equals(resolvedSelector)) {
                throw new ProviderNotFoundException("no provider found for module " + moduleName + ", if you're sure it's not required module and want to remove it, set the selector to -");
            }
            moduleIterator.remove();
            log.info("Remove module {} without any provider", (Object)moduleName);
        }
    }

    private void overrideModuleSettings(ApplicationConfiguration configuration, String key, String value) {
        int moduleAndConfigSeparator = key.indexOf(46);
        if (moduleAndConfigSeparator <= 0) {
            return;
        }
        String moduleName = key.substring(0, moduleAndConfigSeparator);
        String providerSettingSubKey = key.substring(moduleAndConfigSeparator + 1);
        ApplicationConfiguration.ModuleConfiguration moduleConfiguration = configuration.getModuleConfiguration(moduleName);
        if (moduleConfiguration == null) {
            return;
        }
        int providerAndConfigSeparator = providerSettingSubKey.indexOf(46);
        if (providerAndConfigSeparator <= 0) {
            return;
        }
        String providerName = providerSettingSubKey.substring(0, providerAndConfigSeparator);
        String settingKey = providerSettingSubKey.substring(providerAndConfigSeparator + 1);
        if (!moduleConfiguration.has(providerName)) {
            return;
        }
        Properties providerSettings = moduleConfiguration.getProviderConfiguration(providerName);
        if (!providerSettings.containsKey(settingKey)) {
            return;
        }
        Object originValue = providerSettings.get(settingKey);
        Class<?> type = originValue.getClass();
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            providerSettings.put(settingKey, Integer.valueOf(value));
        } else if (type.equals(String.class)) {
            providerSettings.put(settingKey, value);
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            providerSettings.put(settingKey, Long.valueOf(value));
        } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            providerSettings.put(settingKey, Boolean.valueOf(value));
        } else {
            return;
        }
        log.info("The setting has been override by key: {}, value: {}, in {} provider of {} module through {}", new Object[]{settingKey, value, providerName, moduleName, "System.properties"});
    }

    @Generated
    public List<ApplicationConfiguration.ModuleConfiguration> getResolvedConfigurations() {
        return this.resolvedConfigurations;
    }
}

