/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.jfr.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import one.jfr.JFRConverter;
import one.jfr.JfrReader;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.LiveObject;
import org.apache.skywalking.oap.server.library.jfr.type.Arguments;
import org.apache.skywalking.oap.server.library.jfr.type.CallStack;
import org.apache.skywalking.oap.server.library.jfr.type.Classifier;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTree;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTreeBuilder;
import org.apache.skywalking.oap.server.library.jfr.type.JFREventType;

public class JFRToFrameTree
extends JFRConverter {
    private final Map<JFREventType, FrameTreeBuilder> event2builderMap = new HashMap<JFREventType, FrameTreeBuilder>();
    private final Arguments args;

    public JFRToFrameTree(JfrReader jfr, Arguments arguments) {
        super(jfr);
        this.args = arguments;
    }

    @Override
    protected void convertChunk() throws IOException {
        Map<JFREventType, EventAggregator> event2aggMap = this.collectMultiEvents();
        for (Map.Entry<JFREventType, EventAggregator> entry : event2aggMap.entrySet()) {
            final JFREventType event = entry.getKey();
            EventAggregator agg = entry.getValue();
            final FrameTreeBuilder frameTreeBuilder = this.event2builderMap.computeIfAbsent(event, eventType -> new FrameTreeBuilder());
            agg.forEach(new EventAggregator.Visitor(){
                final CallStack stack = new CallStack();
                final double ticksToNanos;
                final boolean scale;
                {
                    this.ticksToNanos = 1.0E9 / (double)((JFRToFrameTree)JFRToFrameTree.this).jfr.ticksPerSec;
                    this.scale = JFREventType.isLockSample(event) && this.ticksToNanos != 1.0;
                }

                public void visit(Event event2, long value) {
                    StackTrace stackTrace = (StackTrace)((JFRToFrameTree)JFRToFrameTree.this).jfr.stackTraces.get((long)event2.stackTraceId);
                    if (stackTrace != null) {
                        long[] methods = stackTrace.methods;
                        byte[] types = stackTrace.types;
                        int[] locations = stackTrace.locations;
                        if (JFRToFrameTree.this.args.isThreads()) {
                            this.stack.push(JFRToFrameTree.this.getThreadName(event2.tid), (byte)3);
                        }
                        if (JFRToFrameTree.this.args.isClassify()) {
                            Classifier.Category category = JFRToFrameTree.this.getCategory(stackTrace);
                            this.stack.push(category.getTitle(), category.getType());
                        }
                        int i = methods.length;
                        while (--i >= 0) {
                            Object methodName = JFRToFrameTree.this.getMethodName(methods[i], types[i]);
                            int location = locations[i] >>> 16;
                            if (location != 0) {
                                methodName = (String)methodName + ":" + location;
                            }
                            this.stack.push((String)methodName, types[i]);
                        }
                        if (event2 instanceof AllocationSample) {
                            AllocationSample allocationSample = (AllocationSample)event2;
                            if (allocationSample.classId != 0) {
                                this.stack.push(JFRToFrameTree.this.getClassName(allocationSample.classId), ((AllocationSample)event2).tlabSize == 0L ? (byte)5 : 2);
                            }
                        } else if (event2 instanceof LiveObject) {
                            LiveObject liveObject = (LiveObject)event2;
                            if (liveObject.classId != 0) {
                                this.stack.push(JFRToFrameTree.this.getClassName(liveObject.classId), (byte)2);
                            }
                        } else if (event2 instanceof ContendedLock) {
                            ContendedLock contendedLock = (ContendedLock)event2;
                            if (contendedLock.classId != 0) {
                                this.stack.push(JFRToFrameTree.this.getClassName(contendedLock.classId), (byte)2);
                            }
                        }
                        frameTreeBuilder.addSample(this.stack, this.scale ? (long)((double)value * this.ticksToNanos) : value);
                        this.stack.clear();
                    }
                }
            });
        }
    }

    public Map<JFREventType, FrameTree> getFrameTreeMap() {
        HashMap<JFREventType, FrameTree> resMap = new HashMap<JFREventType, FrameTree>();
        for (Map.Entry<JFREventType, FrameTreeBuilder> entry : this.event2builderMap.entrySet()) {
            JFREventType event = entry.getKey();
            FrameTreeBuilder frameTreeBuilder = entry.getValue();
            resMap.put(event, frameTreeBuilder.build());
        }
        return resMap;
    }
}

