/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.core.alarm.AlarmRulesWatcherService;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.Rules;
import org.apache.skywalking.oap.server.core.alarm.provider.RulesReader;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.apache.skywalking.oap.server.core.alarm.provider.dingtalk.DingtalkSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.discord.DiscordSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.feishu.FeishuSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.grpc.GRPCAlarmSetting;
import org.apache.skywalking.oap.server.core.alarm.provider.pagerduty.PagerDutySettings;
import org.apache.skywalking.oap.server.core.alarm.provider.slack.SlackSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.webhook.WebhookSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.wechat.WechatSettings;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkSettings;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmRulesWatcher
extends ConfigChangeWatcher
implements AlarmRulesWatcherService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmRulesWatcher.class);
    private volatile Map<String, List<RunningRule>> runningContext = new HashMap<String, List<RunningRule>>();
    private volatile Map<AlarmRule, RunningRule> alarmRuleRunningRuleMap = new HashMap<AlarmRule, RunningRule>();
    private volatile Map<String, Set<String>> exprMetricsMap = new HashMap<String, Set<String>>();
    private volatile Rules rules;
    private volatile String settingsString = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean notifiedByDynamicConfig = new AtomicBoolean(false);
    private final ModuleManager moduleManager;

    public AlarmRulesWatcher(Rules defaultRules, ModuleProvider provider, ModuleManager moduleManager) {
        super("alarm", provider, "alarm-settings");
        this.moduleManager = moduleManager;
        this.notify(defaultRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        this.lock.lock();
        try {
            if (value.getEventType().equals((Object)ConfigChangeWatcher.EventType.DELETE)) {
                this.settingsString = null;
                this.notify(new Rules());
            } else {
                this.settingsString = value.getNewValue();
                RulesReader rulesReader = new RulesReader(new StringReader(value.getNewValue()), this.moduleManager);
                Rules rules = rulesReader.readRules();
                this.notify(rules);
            }
            this.notifiedByDynamicConfig.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initConfig(Rules newRules) {
        this.lock.lock();
        try {
            if (this.notifiedByDynamicConfig.get()) {
                return;
            }
            this.notify(newRules);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notify(Rules newRules) {
        HashMap<AlarmRule, RunningRule> newAlarmRuleRunningRuleMap = new HashMap<AlarmRule, RunningRule>();
        HashMap<String, List<RunningRule>> newRunningContext = new HashMap<String, List<RunningRule>>();
        HashMap<String, Set<String>> newExprMetricsMap = new HashMap<String, Set<String>>();
        newRules.getRules().forEach(rule -> {
            RunningRule runningRule = this.alarmRuleRunningRuleMap.getOrDefault(rule, new RunningRule((AlarmRule)rule, this.moduleManager));
            newAlarmRuleRunningRuleMap.put((AlarmRule)rule, runningRule);
            String expression = rule.getExpression();
            newExprMetricsMap.put(expression, rule.getIncludeMetrics());
            List runningRules = newRunningContext.computeIfAbsent(expression, key -> new ArrayList());
            runningRules.add(runningRule);
        });
        this.rules = newRules;
        this.runningContext = newRunningContext;
        this.alarmRuleRunningRuleMap = newAlarmRuleRunningRuleMap;
        this.exprMetricsMap = newExprMetricsMap;
        log.debug("Update alarm rules to {}", (Object)this.rules);
    }

    public String value() {
        return this.settingsString;
    }

    public List<AlarmRule> getRules() {
        return this.rules.getRules();
    }

    public Map<String, WebhookSettings> getWebHooks() {
        return this.rules.getWebhookSettingsMap();
    }

    public Map<String, GRPCAlarmSetting> getGrpchookSetting() {
        return this.rules.getGrpcAlarmSettingMap();
    }

    public Map<String, SlackSettings> getSlackSettings() {
        return this.rules.getSlackSettingsMap();
    }

    public Map<String, WechatSettings> getWechatSettings() {
        return this.rules.getWechatSettingsMap();
    }

    public Map<String, DingtalkSettings> getDingtalkSettings() {
        return this.rules.getDingtalkSettingsMap();
    }

    public Map<String, FeishuSettings> getFeishuSettings() {
        return this.rules.getFeishuSettingsMap();
    }

    public Map<String, WeLinkSettings> getWeLinkSettings() {
        return this.rules.getWeLinkSettingsMap();
    }

    public Map<String, PagerDutySettings> getPagerDutySettings() {
        return this.rules.getPagerDutySettingsMap();
    }

    public Map<String, DiscordSettings> getDiscordSettings() {
        return this.rules.getDiscordSettingsMap();
    }

    @Generated
    public Map<String, List<RunningRule>> getRunningContext() {
        return this.runningContext;
    }

    @Generated
    public Map<String, Set<String>> getExprMetricsMap() {
        return this.exprMetricsMap;
    }
}

