/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.armeria.common.DefaultRequestHeaders;
import com.linecorp.armeria.common.DefaultRequestHeadersBuilder;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBase;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaderGetters;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.RequestHeadersJsonDeserializer;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;

@JsonDeserialize(using=RequestHeadersJsonDeserializer.class)
public interface RequestHeaders
extends HttpHeaders,
RequestHeaderGetters {
    public static RequestHeadersBuilder builder() {
        return new DefaultRequestHeadersBuilder();
    }

    public static RequestHeadersBuilder builder(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return RequestHeaders.builder().method(method).path(path);
    }

    public static RequestHeaders of(HttpMethod method, String path) {
        return RequestHeaders.builder(method, path).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name, String value) {
        return RequestHeaders.builder(method, path).add(name, value).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name, Object value) {
        return RequestHeaders.builder(method, path).addObject(name, value).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name1, String value1, CharSequence name2, String value2) {
        return RequestHeaders.builder(method, path).add(name1, value1).add(name2, value2).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name1, Object value1, CharSequence name2, Object value2) {
        return RequestHeaders.builder(method, path).addObject(name1, value1).addObject(name2, value2).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name1, String value1, CharSequence name2, String value2, CharSequence name3, String value3) {
        return RequestHeaders.builder(method, path).add(name1, value1).add(name2, value2).add(name3, value3).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name1, Object value1, CharSequence name2, Object value2, CharSequence name3, Object value3) {
        return RequestHeaders.builder(method, path).addObject(name1, value1).addObject(name2, value2).addObject(name3, value3).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name1, String value1, CharSequence name2, String value2, CharSequence name3, String value3, CharSequence name4, String value4) {
        return RequestHeaders.builder(method, path).add(name1, value1).add(name2, value2).add(name3, value3).add(name4, value4).build();
    }

    public static RequestHeaders of(HttpMethod method, String path, CharSequence name1, Object value1, CharSequence name2, Object value2, CharSequence name3, Object value3, CharSequence name4, Object value4) {
        return RequestHeaders.builder(method, path).addObject(name1, value1).addObject(name2, value2).addObject(name3, value3).addObject(name4, value4).build();
    }

    public static RequestHeaders of(HttpHeaders headers) {
        if (headers instanceof RequestHeaders) {
            return (RequestHeaders)headers;
        }
        Objects.requireNonNull(headers, "headers");
        Preconditions.checkArgument(headers.contains(HttpHeaderNames.METHOD), ":method header does not exist.");
        Preconditions.checkArgument(headers.contains(HttpHeaderNames.PATH), ":path header does not exist.");
        if (headers instanceof HttpHeadersBase) {
            return new DefaultRequestHeaders((HttpHeadersBase)((Object)headers));
        }
        return new DefaultRequestHeaders(headers);
    }

    @Override
    public RequestHeadersBuilder toBuilder();

    @Override
    default public RequestHeaders withMutations(Consumer<HttpHeadersBuilder> mutator) {
        return (RequestHeaders)HttpHeaders.super.withMutations(mutator);
    }
}

