/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.log.analyzer.provider.LALConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class LALConfigs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LALConfigs.class);
    private List<LALConfig> rules;

    public static List<LALConfigs> load(String path, List<String> files) throws Exception {
        if (CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        Preconditions.checkArgument((boolean)StringUtil.isNotBlank((String)path), (Object)"path cannot be blank");
        try {
            File[] rules = ResourceUtils.getPathFiles((String)path);
            return Arrays.stream(rules).filter(File::isFile).filter(it -> files.contains(Files.getNameWithoutExtension((String)it.getName()))).map(f -> {
                LALConfigs lALConfigs;
                FileReader r = new FileReader((File)f);
                try {
                    lALConfigs = (LALConfigs)new Yaml().loadAs((Reader)r, LALConfigs.class);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug("Failed to read file {}", f, (Object)e);
                        return null;
                    }
                }
                ((Reader)r).close();
                return lALConfigs;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Failed to load LAL config rules", (Throwable)e);
        }
    }

    @Generated
    public LALConfigs() {
    }

    @Generated
    public List<LALConfig> getRules() {
        return this.rules;
    }

    @Generated
    public void setRules(List<LALConfig> rules) {
        this.rules = rules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LALConfigs)) {
            return false;
        }
        LALConfigs other = (LALConfigs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LALConfig> this$rules = this.getRules();
        List<LALConfig> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LALConfigs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LALConfig> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LALConfigs(rules=" + String.valueOf(this.getRules()) + ")";
    }
}

