/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.filter.FilterChain;
import com.alipay.sofa.rpc.transport.http.AbstractHttpClientHandler;

public class CallbackInvokeClientHandler
extends AbstractHttpClientHandler {
    protected final SofaResponseCallback callback;

    public CallbackInvokeClientHandler(ConsumerConfig consumerConfig, ProviderInfo providerInfo, SofaResponseCallback listener, SofaRequest request, RpcInternalContext context, ClassLoader classLoader) {
        super(consumerConfig, providerInfo, request, context, classLoader);
        this.callback = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOnResponse(Object result) {
        if (this.callback == null) {
            return;
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        SofaResponse response = (SofaResponse)result;
        Throwable throwable = null;
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            RpcInternalContext.setContext(this.context);
            if (EventBus.isEnable(ClientAsyncReceiveEvent.class)) {
                EventBus.post(new ClientAsyncReceiveEvent(this.consumerConfig, this.providerInfo, this.request, response, null));
            }
            this.pickupBaggage(response);
            FilterChain chain = this.consumerConfig.getConsumerBootstrap().getCluster().getFilterChain();
            if (chain != null) {
                chain.onAsyncResponse(this.consumerConfig, this.request, response, null);
            }
            this.recordClientElapseTime();
            if (EventBus.isEnable(ClientEndInvokeEvent.class)) {
                EventBus.post(new ClientEndInvokeEvent(this.request, response, null));
            }
            this.decode(response);
            Object appResp = response.getAppResponse();
            if (response.isError()) {
                SofaRpcException sofaRpcException = new SofaRpcException(199, response.getErrorMsg());
                this.callback.onSofaException(sofaRpcException, this.request.getMethodName(), this.request);
            } else if (appResp instanceof Throwable) {
                throwable = (Throwable)appResp;
                this.callback.onAppException(throwable, this.request.getMethodName(), this.request);
            } else {
                this.callback.onAppResponse(appResp, this.request.getMethodName(), this.request);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            RpcInvokeContext.removeContext();
            RpcInternalContext.removeAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOnException(Throwable e) {
        if (this.callback == null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            FilterChain chain;
            Thread.currentThread().setContextClassLoader(this.classLoader);
            RpcInternalContext.setContext(this.context);
            if (EventBus.isEnable(ClientAsyncReceiveEvent.class)) {
                EventBus.post(new ClientAsyncReceiveEvent(this.consumerConfig, this.providerInfo, this.request, null, e));
            }
            if ((chain = this.consumerConfig.getConsumerBootstrap().getCluster().getFilterChain()) != null) {
                chain.onAsyncResponse(this.consumerConfig, this.request, null, e);
            }
            this.recordClientElapseTime();
            if (EventBus.isEnable(ClientEndInvokeEvent.class)) {
                EventBus.post(new ClientEndInvokeEvent(this.request, null, e));
            }
            SofaRpcException sofaRpcException = e instanceof SofaRpcException ? (SofaRpcException)e : new SofaRpcException(199, e.getMessage(), e);
            this.callback.onSofaException(sofaRpcException, this.request.getMethodName(), this.request);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
            RpcInvokeContext.removeContext();
            RpcInternalContext.removeAllContext();
        }
    }
}

