/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.bolt.BoltClientConnectionManager;

class AloneBoltClientConnectionManager
extends BoltClientConnectionManager {
    public AloneBoltClientConnectionManager(boolean addHook) {
        super(addHook);
    }

    @Override
    protected void checkLeak() {
    }

    @Override
    public Connection getConnection(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        Connection connection;
        if (rpcClient == null || transportConfig == null || url == null) {
            return null;
        }
        try {
            connection = rpcClient.getConnection(url, url.getConnectTimeout());
        }
        catch (RemotingException | InterruptedException e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020010010"), e);
        }
        if (connection == null) {
            return null;
        }
        return connection;
    }

    @Override
    public void closeConnection(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        if (rpcClient == null || transportConfig == null || url == null) {
            return;
        }
    }

    @Override
    public boolean isConnectionFine(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        Connection connection;
        try {
            connection = rpcClient.getConnection(url, url.getConnectTimeout());
        }
        catch (RemotingException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return connection != null && connection.isFine();
    }
}

