/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.bolt;

import com.alipay.remoting.RemotingServer;
import com.alipay.remoting.rpc.RpcServer;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.event.ServerStoppedEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.BusinessPool;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.SofaRejectedExecutionHandler;
import com.alipay.sofa.rpc.server.bolt.BoltServerProcessor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="bolt")
public class BoltServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltServer.class);
    protected volatile boolean started;
    protected RemotingServer remotingServer;
    protected ServerConfig serverConfig;
    protected BoltServerProcessor boltServerProcessor;
    @Deprecated
    protected ThreadPoolExecutor bizThreadPool;
    protected Executor bizExecutor;
    protected Map<String, Invoker> invokerMap = new ConcurrentHashMap<String, Invoker>();

    @Override
    public void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.bizExecutor = this.initExecutor(serverConfig);
        if (this.bizExecutor instanceof ThreadPoolExecutor) {
            this.bizThreadPool = (ThreadPoolExecutor)this.bizExecutor;
        }
        this.boltServerProcessor = new BoltServerProcessor(this);
    }

    protected Executor initExecutor(ServerConfig serverConfig) {
        Executor executor = BusinessPool.initExecutor("SEV-BOLT-BIZ-" + serverConfig.getPort(), serverConfig);
        if (executor instanceof ThreadPoolExecutor) {
            this.configureThreadPoolExecutor((ThreadPoolExecutor)executor, serverConfig);
        }
        return executor;
    }

    protected void configureThreadPoolExecutor(ThreadPoolExecutor executor, ServerConfig serverConfig) {
        executor.setRejectedExecutionHandler(new SofaRejectedExecutionHandler());
        if (serverConfig.isPreStartCore()) {
            executor.prestartAllCoreThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.started) {
            return;
        }
        BoltServer boltServer = this;
        synchronized (boltServer) {
            if (this.started) {
                return;
            }
            this.remotingServer = this.initRemotingServer();
            try {
                if (this.remotingServer.start()) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Bolt server has been bind to {}:{}", this.serverConfig.getBoundHost(), this.serverConfig.getPort());
                    }
                } else {
                    throw new SofaRpcRuntimeException(LogCodes.getLog("010000025"));
                }
                this.started = true;
                if (EventBus.isEnable(ServerStartedEvent.class)) {
                    EventBus.post(new ServerStartedEvent(this.serverConfig, this.bizThreadPool));
                }
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000025"), e);
            }
        }
    }

    protected RemotingServer initRemotingServer() {
        RpcServer remotingServer = new RpcServer(this.serverConfig.getBoundHost(), this.serverConfig.getPort());
        remotingServer.registerUserProcessor((UserProcessor)this.boltServerProcessor);
        return remotingServer;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasNoEntry() {
        return this.invokerMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        BoltServer boltServer = this;
        synchronized (boltServer) {
            if (!this.started) {
                return;
            }
            try {
                this.remotingServer.stop();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (EventBus.isEnable(ServerStoppedEvent.class)) {
                EventBus.post(new ServerStoppedEvent(this.serverConfig));
            }
            this.remotingServer = null;
            this.started = false;
        }
    }

    @Override
    public void registerProcessor(ProviderConfig providerConfig, Invoker instance) {
        String key = ConfigUniqueNameGenerator.getUniqueName(providerConfig);
        this.invokerMap.put(key, instance);
        ReflectCache.registerServiceClassLoader(key, providerConfig.getProxyClass().getClassLoader());
        for (Method m : providerConfig.getProxyClass().getMethods()) {
            ReflectCache.putOverloadMethodCache(key, m);
        }
    }

    @Override
    public void unRegisterProcessor(ProviderConfig providerConfig, boolean closeIfNoEntry) {
        String key = ConfigUniqueNameGenerator.getUniqueName(providerConfig);
        this.invokerMap.remove(key);
        this.cleanReflectCache(providerConfig);
        if (closeIfNoEntry && this.invokerMap.isEmpty()) {
            this.stop();
        }
    }

    @Override
    public void destroy() {
        if (!this.started) {
            return;
        }
        int stopTimeout = this.serverConfig.getStopTimeout();
        this.destroyThreadPool(this.bizExecutor, stopTimeout);
        this.stop();
    }

    private void destroyThreadPool(Executor executor, int stopWaitTime) {
        if (stopWaitTime > 0) {
            if (executor instanceof ThreadPoolExecutor) {
                this.threadPoolExecutorDestroy((ThreadPoolExecutor)executor, stopWaitTime);
            } else if (executor instanceof ExecutorService) {
                this.executorServiceDestroy((ExecutorService)executor, stopWaitTime);
            }
        }
    }

    private void threadPoolExecutorDestroy(ThreadPoolExecutor executor, int stopWaitTime) {
        AtomicInteger count = this.boltServerProcessor.processingCount;
        if (count.get() > 0 || executor.getQueue().size() > 0) {
            long start = RpcRuntimeContext.now();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There are {} call in processing and {} call in queue, wait {} ms to end", count, executor.getQueue().size(), stopWaitTime);
            }
            while ((count.get() > 0 || executor.getQueue().size() > 0) && RpcRuntimeContext.now() - start < (long)stopWaitTime) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        executor.shutdown();
    }

    private void executorServiceDestroy(ExecutorService executorService, int stopWaitTime) {
        AtomicInteger count = this.boltServerProcessor.processingCount;
        if (count.get() > 0) {
            long start = RpcRuntimeContext.now();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There are {} call in processing, wait {} ms to end", count, stopWaitTime);
            }
            while (count.get() > 0 && RpcRuntimeContext.now() - start < (long)stopWaitTime) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        executorService.shutdown();
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (hook != null) {
            hook.preDestroy();
        }
        this.destroy();
        if (hook != null) {
            hook.postDestroy();
        }
    }

    @Deprecated
    public ThreadPoolExecutor getBizThreadPool() {
        return this.bizThreadPool;
    }

    public Executor getBizExecutor() {
        return this.bizExecutor;
    }

    public Invoker findInvoker(String serviceName) {
        return this.invokerMap.get(serviceName);
    }

    public void cleanReflectCache(ProviderConfig providerConfig) {
        String key = ConfigUniqueNameGenerator.getUniqueName(providerConfig);
        ReflectCache.unRegisterServiceClassLoader(key);
        ReflectCache.invalidateMethodCache(key);
        ReflectCache.invalidateMethodSigsCache(key);
        ReflectCache.invalidateOverloadMethodCache(key);
    }

    @Deprecated
    protected ThreadPoolExecutor initThreadPool(ServerConfig serverConfig) {
        ThreadPoolExecutor threadPool = BusinessPool.initPool(serverConfig);
        threadPool.setThreadFactory(new NamedThreadFactory("SEV-BOLT-BIZ-" + serverConfig.getPort(), serverConfig.isDaemon()));
        this.configureThreadPoolExecutor(threadPool, serverConfig);
        return threadPool;
    }
}

