/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.gzip;

import com.alipay.sofa.rpc.codec.Compressor;
import com.alipay.sofa.rpc.ext.Extension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@Extension(value="gzip", code=4)
public class GzipRpcCompressor
implements Compressor {
    @Override
    public byte[] compress(byte[] src) {
        if (null == src || 0 == src.length) {
            return new byte[0];
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteOutStream);){
            gzipOutputStream.write(src);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return byteOutStream.toByteArray();
    }

    @Override
    public byte[] deCompress(byte[] src) {
        if (null == src || 0 == src.length) {
            return new byte[0];
        }
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(src);
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteInStream);){
            int readByteNum;
            byte[] bufferArr = new byte[256];
            while ((readByteNum = gzipInputStream.read(bufferArr)) >= 0) {
                byteOutStream.write(bufferArr, 0, readByteNum);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return byteOutStream.toByteArray();
    }
}

