/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rabbitmq.handler;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.handler.AbstractLogPluginDataHandler;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.rabbitmq.cache.RabbitmqClientCache;
import org.apache.shenyu.plugin.logging.rabbitmq.client.RabbitmqLogCollectClient;
import org.apache.shenyu.plugin.logging.rabbitmq.config.RabbitmqLogCollectConfig;
import org.apache.shenyu.plugin.logging.rabbitmq.conllector.RabbitmqLogCollector;

public class LoggingRabbitmqPluginDataHandler
extends AbstractLogPluginDataHandler<RabbitmqLogCollectConfig.RabbitmqLogConfig, RabbitmqLogCollectConfig.LogApiConfig> {
    private static final RabbitmqLogCollectClient RABBITMQ_LOG_COLLECT_CLIENT = new RabbitmqLogCollectClient();
    private static final AtomicBoolean MULTI_CLIENT = new AtomicBoolean(false);

    public static RabbitmqLogCollectClient getRabbitmqLogCollectClient() {
        return RABBITMQ_LOG_COLLECT_CLIENT;
    }

    public static boolean getMultiClient() {
        return MULTI_CLIENT.get();
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_RABBITMQ.getName();
    }

    protected LogCollector logCollector() {
        return RabbitmqLogCollector.getInstance();
    }

    protected void doRefreshConfig(RabbitmqLogCollectConfig.RabbitmqLogConfig globalLogConfig) {
        RabbitmqLogCollectConfig.INSTANCE.setRabbitmqLogConfig(globalLogConfig);
        RABBITMQ_LOG_COLLECT_CLIENT.initClient(globalLogConfig);
    }

    public void handlerSelector(SelectorData selectorData) {
        RabbitmqLogCollectConfig.LogApiConfig oConfig;
        Map rabbitmqJsonMap = GsonUtils.getInstance().convertToMap(selectorData.getHandle());
        Object hostObj = rabbitmqJsonMap.get("host");
        if (Objects.isNull(hostObj) || !(hostObj instanceof String) || ((String)hostObj).trim().isEmpty()) {
            RabbitmqClientCache.getInstance().invalidate(selectorData.getId());
            Optional.ofNullable(RabbitmqClientCache.getInstance().getClientCache()).filter(Map::isEmpty).ifPresent(map -> MULTI_CLIENT.set(false));
            return;
        }
        RabbitmqLogCollectConfig.LogApiConfig nConfig = (RabbitmqLogCollectConfig.LogApiConfig)((Object)GsonUtils.getInstance().fromJson(selectorData.getHandle(), RabbitmqLogCollectConfig.LogApiConfig.class));
        if (Objects.equals((Object)nConfig, (Object)(oConfig = (RabbitmqLogCollectConfig.LogApiConfig)((Object)LoggingRabbitmqPluginDataHandler.getSelectApiConfigMap().get(selectorData.getId()))))) {
            return;
        }
        RabbitmqClientCache.getInstance().invalidate(selectorData.getId());
        if (Objects.isNull((Object)nConfig)) {
            return;
        }
        RabbitmqClientCache.getInstance().initRabbitmqClient(selectorData.getId(), nConfig);
        MULTI_CLIENT.set(true);
        if (StringUtils.isNotEmpty((CharSequence)nConfig.getSampleRate())) {
            nConfig.setSampler(LogCollectConfigUtils.setSampler((String)nConfig.getSampleRate()));
        }
        LoggingRabbitmqPluginDataHandler.getSelectApiConfigMap().put(selectorData.getId(), nConfig);
    }

    public void removePlugin(PluginData pluginData) {
        RabbitmqClientCache.getInstance().invalidateAll();
        super.removePlugin(pluginData);
    }

    public void removeSelector(SelectorData selectorData) {
        RabbitmqClientCache.getInstance().invalidate(selectorData.getId());
        super.removeSelector(selectorData);
    }
}

