/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;

public class LoggerFactory {
    private static final LoggerContext logContext = (LoggerContext)org.slf4j.LoggerFactory.getILoggerFactory();
    private static final String CLIENT_LOG_NAME = "TARS_CLIENT_LOGGER";
    private static final String OM_LOG_NAME = "OM_LOGGER";

    public static int resetLogBack() {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)logContext);
        logContext.reset();
        try {
            configurator.doConfigure("logback.xml");
            return 0;
        }
        catch (JoranException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void resetLogLevel(Level level) {
        Logger root = LoggerFactory.getLogger("ROOT");
        root.setLevel(level);
    }

    public static Logger getLogger() {
        return logContext.getLogger("");
    }

    public static Logger getLogger(String logName) {
        return logContext.getLogger(logName);
    }

    public static Logger getOmLogger() {
        return logContext.getLogger(OM_LOG_NAME);
    }

    public static Logger getClientLogger() {
        return LoggerFactory.getLogger(CLIENT_LOG_NAME);
    }
}

