/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.ObjectProxy;
import com.qq.tars.client.ObjectProxyFactory;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.ServantProxyFactory;
import com.qq.tars.client.support.ClientPoolManager;
import com.qq.tars.common.support.ScheduledExecutorManager;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.net.client.ticket.TicketManager;
import com.qq.tars.net.client.ticket.TimeoutManager;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.ProtocolInvoker;
import com.qq.tars.rpc.exc.CommunicatorConfigException;
import com.qq.tars.support.query.QueryHelper;
import com.qq.tars.support.query.prx.EndpointF;
import com.qq.tars.support.stat.StatHelper;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public final class Communicator {
    private volatile String id;
    private volatile CommunicatorConfig communicatorConfig;
    private volatile ThreadPoolExecutor threadPoolExecutor;
    private final ServantProxyFactory servantProxyFactory = new ServantProxyFactory(this);
    private final ObjectProxyFactory objectProxyFactory = new ObjectProxyFactory(this);
    private final QueryHelper queryHelper = new QueryHelper(this);
    private final StatHelper statHelper = new StatHelper(this);
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean inited = new AtomicBoolean(false);

    Communicator(CommunicatorConfig config) {
        if (config != null) {
            this.initCommunicator(config);
        }
    }

    public <T> T stringToProxy(Class<T> clazz, String objName) throws CommunicatorConfigException {
        return this.stringToProxy(clazz, objName, null, null, null, null);
    }

    public <T> T stringToProxy(Class<T> clazz, String objName, String setDivision) throws CommunicatorConfigException {
        return this.stringToProxy(clazz, objName, setDivision, null, null, null);
    }

    public <T> T stringToProxy(Class<T> clazz, ServantProxyConfig servantProxyConfig) throws CommunicatorConfigException {
        return this.stringToProxy(clazz, servantProxyConfig.getObjectName(), servantProxyConfig.getSetDivision(), servantProxyConfig, null, null);
    }

    @Deprecated
    public <T> T stringToProxy(Class<T> clazz, ServantProxyConfig servantProxyConfig, LoadBalance<T> loadBalance) throws CommunicatorConfigException {
        return this.stringToProxy(clazz, servantProxyConfig.getObjectName(), servantProxyConfig.getSetDivision(), servantProxyConfig, loadBalance, null);
    }

    private <T> T stringToProxy(Class<T> clazz, String objName, String setDivision, ServantProxyConfig servantProxyConfig, LoadBalance<T> loadBalance, ProtocolInvoker<T> protocolInvoker) throws CommunicatorConfigException {
        if (!this.inited.get()) {
            throw new CommunicatorConfigException("communicator uninitialized!");
        }
        return (T)this.getServantProxyFactory().getServantProxy(clazz, objName, setDivision, servantProxyConfig, loadBalance, protocolInvoker);
    }

    @Deprecated
    public void initialize(CommunicatorConfig config) throws CommunicatorConfigException {
        this.initCommunicator(config);
    }

    public void shutdown() {
        this.threadPoolExecutor.shutdownNow();
        ScheduledExecutorManager.getInstance().shutdownNow();
        TicketManager.shutdown();
        TimeoutManager.shutdown();
        Iterator<Object> it = this.servantProxyFactory.getProxyIterator();
        while (it.hasNext()) {
            Object proxy = it.next();
            ((ObjectProxy)Proxy.getInvocationHandler(proxy)).destroy();
        }
    }

    private void initCommunicator(CommunicatorConfig config) throws CommunicatorConfigException {
        block6: {
            if (this.inited.get()) {
                return;
            }
            this.lock.lock();
            try {
                if (this.inited.get()) break block6;
                try {
                    this.id = StringUtils.isEmpty(config.getLocator()) ? UUID.randomUUID().toString().replaceAll("-", "") : UUID.nameUUIDFromBytes(config.getLocator().getBytes()).toString().replaceAll("-", "");
                    this.communicatorConfig = config;
                    this.threadPoolExecutor = ClientPoolManager.getClientThreadPoolExecutor(config);
                    this.inited.set(true);
                }
                catch (Throwable e) {
                    this.inited.set(false);
                    throw new CommunicatorConfigException(e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    String getId() {
        return this.id;
    }

    protected ServantProxyFactory getServantProxyFactory() {
        return this.servantProxyFactory;
    }

    protected ObjectProxyFactory getObjectProxyFactory() {
        return this.objectProxyFactory;
    }

    public CommunicatorConfig getCommunicatorConfig() {
        return this.communicatorConfig;
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    protected QueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    public StatHelper getStatHelper() {
        return this.statHelper;
    }

    public List<EndpointF> getEndpoint4All(String objectName) {
        return this.getQueryHelper().findObjectById(objectName);
    }
}

