/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.type.BreezeType;

public class TypeByteArray
implements BreezeType<byte[]> {
    private static final byte[] EmptyByteArray = new byte[0];

    TypeByteArray() {
    }

    public static byte[] readBytes(BreezeBuffer buffer) throws BreezeException {
        int size = BreezeReader.getAndCheckSize(buffer);
        if (size == 0) {
            return EmptyByteArray;
        }
        byte[] b = new byte[size];
        buffer.get(b);
        return b;
    }

    @Override
    public byte getType() {
        return -99;
    }

    @Override
    public byte[] read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (withType) {
            BreezeReader.checkType(buffer, (byte)-99);
        }
        return TypeByteArray.readBytes(buffer);
    }

    @Override
    public void write(BreezeBuffer buffer, byte[] value, boolean withType) throws BreezeException {
        if (withType) {
            buffer.put((byte)-99);
        }
        buffer.putInt(value.length);
        buffer.put(value);
    }
}

