/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypePackedArray;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TypeArray
implements BreezeType<List<?>> {
    private Type vType;

    public TypeArray() {
        this.vType = Object.class;
    }

    public TypeArray(Type type) throws BreezeException {
        if (type == null) {
            throw new BreezeException("value type must not null in TypeArray");
        }
        this.vType = type;
    }

    @Override
    public byte getType() {
        return -38;
    }

    @Override
    public List<?> read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        int size;
        if (withType) {
            byte type = buffer.get();
            if (type == -103) {
                return null;
            }
            if (type == -36) {
                return new TypePackedArray().read(buffer, false);
            }
            if (type != -38) {
                throw new BreezeException("unsupported by TypeArray. type:" + type);
            }
        }
        if ((size = (int)buffer.getVarint()) > Breeze.MAX_ELEM_SIZE) {
            throw new BreezeException("breeze array size over limit. size" + size);
        }
        ArrayList list = new ArrayList(size);
        this.readBySize(buffer, list, this.vType, size);
        return list;
    }

    public <T> void readBySize(BreezeBuffer buffer, Collection<T> collection, Type vType, int size) throws BreezeException {
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            collection.add(BreezeReader.readObjectByType(buffer, vType));
        }
    }

    @Override
    public void write(BreezeBuffer buffer, List<?> value, boolean withType) throws BreezeException {
        this.writeCollection(buffer, value, withType);
    }

    public void writeCollection(BreezeBuffer buffer, Collection<?> value, boolean withType) throws BreezeException {
        BreezeWriter.checkWriteCount(buffer, value);
        if (withType) {
            buffer.put((byte)-38);
        }
        int size = value.size();
        buffer.putVarint(size);
        if (size == 0) {
            return;
        }
        for (Object v : value) {
            BreezeWriter.writeObject(buffer, v);
        }
    }

    public void writeArray(BreezeBuffer buffer, Object[] value, boolean withType) throws BreezeException {
        BreezeWriter.checkWriteCount(buffer, value);
        if (withType) {
            buffer.put((byte)-38);
        }
        buffer.putVarint(value.length);
        if (value.length == 0) {
            return;
        }
        for (Object v : value) {
            BreezeWriter.writeObject(buffer, v);
        }
    }
}

