/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tencent.cls.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.tencentcloudapi.cls.producer.AsyncProducerClient;
import com.tencentcloudapi.cls.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.producer.Result;
import com.tencentcloudapi.cls.producer.common.LogItem;
import com.tencentcloudapi.cls.producer.errors.LogSizeTooLargeException;
import com.tencentcloudapi.cls.producer.errors.MaxBatchCountExceedException;
import com.tencentcloudapi.cls.producer.errors.ProducerException;
import com.tencentcloudapi.cls.producer.errors.ResultFailedException;
import com.tencentcloudapi.cls.producer.util.NetworkUtils;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.constant.GenericLoggingConstant;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.tencent.cls.config.TencentLogCollectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class TencentClsLogCollectClient
extends AbstractLogConsumeClient<TencentLogCollectConfig.TencentClsLogConfig, ShenyuRequestLog> {
    private AsyncProducerClient client;
    private String topic;
    private ThreadPoolExecutor threadExecutor;

    public void initClient0(@NonNull TencentLogCollectConfig.TencentClsLogConfig tencentClsLogConfig) {
        String secretId = tencentClsLogConfig.getSecretId();
        String secretKey = tencentClsLogConfig.getSecretKey();
        String endpoint = tencentClsLogConfig.getEndpoint();
        this.topic = tencentClsLogConfig.getTopic();
        if (StringUtils.isBlank((CharSequence)secretId) || StringUtils.isBlank((CharSequence)secretKey) || StringUtils.isBlank((CharSequence)this.topic) || StringUtils.isBlank((CharSequence)endpoint)) {
            LOG.error("init Tencent cls client error, please check secretId, secretKey, topic or host");
            return;
        }
        AsyncProducerConfig config = new AsyncProducerConfig(endpoint, secretId, secretKey, NetworkUtils.getLocalMachineIP());
        Optional.ofNullable(tencentClsLogConfig.getTotalSizeInBytes()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setTotalSizeInBytes(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getMaxSendThreadCount()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setSendThreadCount(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getMaxBlockSec()).map(Long::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setMaxBlockMs(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getMaxBatchSize()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setBatchSizeThresholdInBytes(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getMaxBatchCount()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setBatchCountThreshold(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getLingerMs()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setLingerMs(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getRetries()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setRetries(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getMaxReservedAttempts()).map(Integer::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setMaxReservedAttempts(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getBaseRetryBackoffMs()).map(Long::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setBaseRetryBackoffMs(arg_0));
        Optional.ofNullable(tencentClsLogConfig.getMaxRetryBackoffMs()).map(Long::valueOf).ifPresent(arg_0 -> ((AsyncProducerConfig)config).setMaxRetryBackoffMs(arg_0));
        this.threadExecutor = TencentClsLogCollectClient.createThreadPoolExecutor(tencentClsLogConfig.getSendThreadCount());
        try {
            this.client = new AsyncProducerClient(config);
        }
        catch (Exception e) {
            LOG.warn("TencentClsLogCollectClient initClient error message:{}", (Object)e.getMessage());
        }
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) {
        logs.forEach(this::sendLog);
    }

    public void close0() {
        if (Objects.nonNull(this.client)) {
            try {
                this.client.close();
            }
            catch (ProducerException | InterruptedException e) {
                LOG.error("Close producer error.");
            }
        }
    }

    private void sendLog(ShenyuRequestLog log) {
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem logItem = new LogItem((long)((int)(System.currentTimeMillis() / 1000L)));
        logItem.PushBack("level", "info");
        logItem.PushBack("name", log.getRequestUri());
        logItem.PushBack("message", GsonUtils.getGson().toJson((Object)log));
        logItems.add(logItem);
        try {
            ListenableFuture f = this.client.putLogs(this.topic, logItems, result -> {});
            Futures.addCallback((ListenableFuture)f, (FutureCallback)new ProducerFutureCallback(this.topic), (Executor)this.threadExecutor);
        }
        catch (InterruptedException e) {
            LOG.warn("The current thread has been interrupted during send logs.");
        }
        catch (Exception e) {
            if (e instanceof MaxBatchCountExceedException) {
                LOG.error("The logs exceeds the maximum batch count, e={}", (Object)e.getMessage());
            }
            if (e instanceof LogSizeTooLargeException) {
                LOG.error("The size of log is larger than the maximum allowable size, e={}", (Object)e.getMessage());
            }
            LOG.error("Failed to send logs, e={}", (Object)e.getMessage());
        }
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(int sendThreadCount) {
        int threadCount = sendThreadCount;
        if (threadCount > GenericLoggingConstant.MAX_ALLOW_THREADS) {
            LOG.warn("send thread count number too large!");
            threadCount = GenericLoggingConstant.MAX_ALLOW_THREADS;
        }
        return new ThreadPoolExecutor(threadCount, GenericLoggingConstant.MAX_ALLOW_THREADS, 60000L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(GenericLoggingConstant.MAX_QUEUE_NUMBER), ShenyuThreadFactory.create((String)"shenyu-tencent-cls", (boolean)true), new ThreadPoolExecutor.AbortPolicy());
    }

    private static final class ProducerFutureCallback
    implements FutureCallback<Result> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProducerFutureCallback.class);
        private final String topic;

        ProducerFutureCallback(String topic) {
            this.topic = topic;
        }

        public void onSuccess(@Nullable Result result) {
            LOGGER.info("Send logs to Tencent cls successfully.");
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof ResultFailedException) {
                Result result = ((ResultFailedException)throwable).getResult();
                LOGGER.error("Failed to send logs, topic={}, result={}", (Object)this.topic, (Object)result);
            } else {
                LOGGER.error("Failed to send log, e={}", (Object)throwable.getMessage());
            }
        }
    }
}

