/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support.command;

import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.FailbackRegistry;
import com.weibo.api.motan.registry.support.command.CommandListener;
import com.weibo.api.motan.registry.support.command.CommandServiceManager;
import com.weibo.api.motan.registry.support.command.RpcCommand;
import com.weibo.api.motan.registry.support.command.RpcCommandUtil;
import com.weibo.api.motan.registry.support.command.ServiceListener;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class CommandFailbackRegistry
extends FailbackRegistry {
    private ConcurrentHashMap<URL, CommandServiceManager> commandManagerMap = new ConcurrentHashMap();

    public CommandFailbackRegistry(URL url) {
        super(url);
        LoggerUtil.info("CommandFailbackRegistry init. url: " + url.toSimpleString());
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        LoggerUtil.info("CommandFailbackRegistry subscribe. url: " + url.toSimpleString());
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
        manager.addNotifyListener(listener);
        this.subscribeService(urlCopy, manager);
        this.subscribeCommand(urlCopy, manager);
        List<URL> urls = this.doDiscover(urlCopy);
        if (urls != null && urls.size() > 0) {
            this.notify(urlCopy, listener, urls);
        }
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        LoggerUtil.info("CommandFailbackRegistry unsubscribe. url: " + url.toSimpleString());
        URL urlCopy = url.createCopy();
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        manager.removeNotifyListener(listener);
        this.unsubscribeService(urlCopy, manager);
        this.unsubscribeCommand(urlCopy, manager);
    }

    @Override
    protected List<URL> doDiscover(URL url) {
        LoggerUtil.info("CommandFailbackRegistry discover. url: " + url.toSimpleString());
        URL urlCopy = url.createCopy();
        String commandStr = this.discoverCommand(urlCopy);
        RpcCommand rpcCommand = null;
        if (StringUtils.isNotEmpty((CharSequence)commandStr)) {
            rpcCommand = RpcCommandUtil.stringToCommand(commandStr);
        }
        LoggerUtil.info("CommandFailbackRegistry discover command. commandStr: " + commandStr + ", rpccommand " + (rpcCommand == null ? "is null." : "is not null."));
        CommandServiceManager manager = this.getCommandServiceManager(urlCopy);
        List<URL> finalResult = manager.discoverServiceWithCommand(new HashMap<String, Integer>(), rpcCommand);
        manager.setCommandCache(commandStr);
        LoggerUtil.info("CommandFailbackRegistry discover size: " + (finalResult == null ? "0" : Integer.valueOf(finalResult.size())));
        return finalResult;
    }

    public List<URL> commandPreview(URL url, RpcCommand rpcCommand, String previewIP) {
        CommandServiceManager manager = this.getCommandServiceManager(url.createCopy());
        return manager.discoverServiceWithCommand(new HashMap<String, Integer>(), rpcCommand, previewIP);
    }

    private CommandServiceManager getCommandServiceManager(URL urlCopy) {
        CommandServiceManager manager = this.commandManagerMap.get(urlCopy);
        if (manager == null) {
            manager = new CommandServiceManager(urlCopy);
            manager.setRegistry(this);
            CommandServiceManager manager1 = this.commandManagerMap.putIfAbsent(urlCopy, manager);
            if (manager1 != null) {
                manager = manager1;
            }
        }
        return manager;
    }

    public ConcurrentHashMap<URL, CommandServiceManager> getCommandManagerMap() {
        return this.commandManagerMap;
    }

    protected abstract void subscribeService(URL var1, ServiceListener var2);

    protected abstract void subscribeCommand(URL var1, CommandListener var2);

    protected abstract void unsubscribeService(URL var1, ServiceListener var2);

    protected abstract void unsubscribeCommand(URL var1, CommandListener var2);

    protected abstract List<URL> discoverService(URL var1);

    protected abstract String discoverCommand(URL var1);
}

