/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.SnapshotSort;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetSnapshotRequest
extends RequestBase {
    @Nullable
    private final String after;
    @Nullable
    private final String fromSortValue;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeRepository;
    @Nullable
    private final Boolean indexDetails;
    @Nullable
    private final Boolean indexNames;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Integer offset;
    @Nullable
    private final SortOrder order;
    private final String repository;
    @Nullable
    private final Integer size;
    @Nullable
    private final String slmPolicyFilter;
    private final List<String> snapshot;
    @Nullable
    private final SnapshotSort sort;
    @Nullable
    private final Boolean verbose;
    public static final Endpoint<GetSnapshotRequest, GetSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetSnapshotRequest, GetSnapshotResponse>("es/snapshot.get", request -> "GET", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("repository", request.repository);
            params.put("snapshot", request.snapshot.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.offset != null) {
            params.put("offset", String.valueOf(request.offset));
        }
        if (request.fromSortValue != null) {
            params.put("from_sort_value", request.fromSortValue);
        }
        if (request.indexNames != null) {
            params.put("index_names", String.valueOf(request.indexNames));
        }
        if (request.indexDetails != null) {
            params.put("index_details", String.valueOf(request.indexDetails));
        }
        if (request.sort != null) {
            params.put("sort", request.sort.jsonValue());
        }
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.includeRepository != null) {
            params.put("include_repository", String.valueOf(request.includeRepository));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.after != null) {
            params.put("after", request.after);
        }
        if (request.slmPolicyFilter != null) {
            params.put("slm_policy_filter", request.slmPolicyFilter);
        }
        if (request.order != null) {
            params.put("order", request.order.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetSnapshotResponse._DESERIALIZER);

    private GetSnapshotRequest(Builder builder) {
        this.after = builder.after;
        this.fromSortValue = builder.fromSortValue;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeRepository = builder.includeRepository;
        this.indexDetails = builder.indexDetails;
        this.indexNames = builder.indexNames;
        this.masterTimeout = builder.masterTimeout;
        this.offset = builder.offset;
        this.order = builder.order;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.size = builder.size;
        this.slmPolicyFilter = builder.slmPolicyFilter;
        this.snapshot = ApiTypeHelper.unmodifiableRequired(builder.snapshot, (Object)this, "snapshot");
        this.sort = builder.sort;
        this.verbose = builder.verbose;
    }

    public static GetSnapshotRequest of(Function<Builder, ObjectBuilder<GetSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String after() {
        return this.after;
    }

    @Nullable
    public final String fromSortValue() {
        return this.fromSortValue;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeRepository() {
        return this.includeRepository;
    }

    @Nullable
    public final Boolean indexDetails() {
        return this.indexDetails;
    }

    @Nullable
    public final Boolean indexNames() {
        return this.indexNames;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Integer offset() {
        return this.offset;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    public final String repository() {
        return this.repository;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String slmPolicyFilter() {
        return this.slmPolicyFilter;
    }

    public final List<String> snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final SnapshotSort sort() {
        return this.sort;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetSnapshotRequest> {
        @Nullable
        private String after;
        @Nullable
        private String fromSortValue;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeRepository;
        @Nullable
        private Boolean indexDetails;
        @Nullable
        private Boolean indexNames;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Integer offset;
        @Nullable
        private SortOrder order;
        private String repository;
        @Nullable
        private Integer size;
        @Nullable
        private String slmPolicyFilter;
        private List<String> snapshot;
        @Nullable
        private SnapshotSort sort;
        @Nullable
        private Boolean verbose;

        public final Builder after(@Nullable String value) {
            this.after = value;
            return this;
        }

        public final Builder fromSortValue(@Nullable String value) {
            this.fromSortValue = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder includeRepository(@Nullable Boolean value) {
            this.includeRepository = value;
            return this;
        }

        public final Builder indexDetails(@Nullable Boolean value) {
            this.indexDetails = value;
            return this;
        }

        public final Builder indexNames(@Nullable Boolean value) {
            this.indexNames = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder offset(@Nullable Integer value) {
            this.offset = value;
            return this;
        }

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder slmPolicyFilter(@Nullable String value) {
            this.slmPolicyFilter = value;
            return this;
        }

        public final Builder snapshot(List<String> list) {
            this.snapshot = Builder._listAddAll(this.snapshot, list);
            return this;
        }

        public final Builder snapshot(String value, String ... values) {
            this.snapshot = Builder._listAdd(this.snapshot, value, values);
            return this;
        }

        public final Builder sort(@Nullable SnapshotSort value) {
            this.sort = value;
            return this;
        }

        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetSnapshotRequest build() {
            this._checkSingleUse();
            return new GetSnapshotRequest(this);
        }
    }
}

