/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class VerifyIndex
implements JsonpSerializable {
    @Nullable
    private final Time checkIndexTime;
    private final long checkIndexTimeInMillis;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<VerifyIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VerifyIndex::setupVerifyIndexDeserializer);

    private VerifyIndex(Builder builder) {
        this.checkIndexTime = builder.checkIndexTime;
        this.checkIndexTimeInMillis = ApiTypeHelper.requireNonNull(builder.checkIndexTimeInMillis, this, "checkIndexTimeInMillis");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static VerifyIndex of(Function<Builder, ObjectBuilder<VerifyIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time checkIndexTime() {
        return this.checkIndexTime;
    }

    public final long checkIndexTimeInMillis() {
        return this.checkIndexTimeInMillis;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.checkIndexTime != null) {
            generator.writeKey("check_index_time");
            this.checkIndexTime.serialize(generator, mapper);
        }
        generator.writeKey("check_index_time_in_millis");
        generator.write(this.checkIndexTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupVerifyIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkIndexTime, Time._DESERIALIZER, "check_index_time");
        op.add(Builder::checkIndexTimeInMillis, JsonpDeserializer.longDeserializer(), "check_index_time_in_millis");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<VerifyIndex> {
        @Nullable
        private Time checkIndexTime;
        private Long checkIndexTimeInMillis;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;

        public final Builder checkIndexTime(@Nullable Time value) {
            this.checkIndexTime = value;
            return this;
        }

        public final Builder checkIndexTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.checkIndexTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder checkIndexTimeInMillis(long value) {
            this.checkIndexTimeInMillis = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public VerifyIndex build() {
            this._checkSingleUse();
            return new VerifyIndex(this);
        }
    }
}

