/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;

@JsonpDeserializable
public class TermsQuery
extends QueryBase
implements ApiKeyQueryVariant,
QueryVariant {
    private final String field;
    private final TermsQueryField terms;
    public static final JsonpDeserializer<TermsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsQuery::setupTermsQueryDeserializer);

    private TermsQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.terms = ApiTypeHelper.requireNonNull(builder.terms, this, "terms");
    }

    public static TermsQuery of(Function<Builder, ObjectBuilder<TermsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ApiKeyQuery.Kind _apiKeyQueryKind() {
        return ApiKeyQuery.Kind.Terms;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Terms;
    }

    public final String field() {
        return this.field;
    }

    public final TermsQueryField terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.terms.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
    }

    protected static void setupTermsQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.terms(TermsQueryField._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermsQuery> {
        private String field;
        private TermsQueryField terms;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder terms(TermsQueryField value) {
            this.terms = value;
            return this;
        }

        public final Builder terms(Function<TermsQueryField.Builder, ObjectBuilder<TermsQueryField>> fn) {
            return this.terms(fn.apply(new TermsQueryField.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsQuery build() {
            this._checkSingleUse();
            return new TermsQuery(this);
        }
    }
}

