/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HtmlStripCharFilter
extends CharFilterBase
implements CharFilterDefinitionVariant {
    private final List<String> escapedTags;
    public static final JsonpDeserializer<HtmlStripCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HtmlStripCharFilter::setupHtmlStripCharFilterDeserializer);

    private HtmlStripCharFilter(Builder builder) {
        super(builder);
        this.escapedTags = ApiTypeHelper.unmodifiable(builder.escapedTags);
    }

    public static HtmlStripCharFilter of(Function<Builder, ObjectBuilder<HtmlStripCharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CharFilterDefinition.Kind _charFilterDefinitionKind() {
        return CharFilterDefinition.Kind.HtmlStrip;
    }

    public final List<String> escapedTags() {
        return this.escapedTags;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "html_strip");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.escapedTags)) {
            generator.writeKey("escaped_tags");
            generator.writeStartArray();
            for (String item0 : this.escapedTags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupHtmlStripCharFilterDeserializer(ObjectDeserializer<Builder> op) {
        CharFilterBase.setupCharFilterBaseDeserializer(op);
        op.add(Builder::escapedTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "escaped_tags");
        op.ignore("type");
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HtmlStripCharFilter> {
        @Nullable
        private List<String> escapedTags;

        public final Builder escapedTags(List<String> list) {
            this.escapedTags = Builder._listAddAll(this.escapedTags, list);
            return this;
        }

        public final Builder escapedTags(String value, String ... values) {
            this.escapedTags = Builder._listAdd(this.escapedTags, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HtmlStripCharFilter build() {
            this._checkSingleUse();
            return new HtmlStripCharFilter(this);
        }
    }
}

