/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.HttpClientConnectionImpl;
import com.clickhouse.client.http.HttpUrlConnectionImpl;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.http.config.HttpConnectionProvider;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ClickHouseHttpConnectionFactory {
    public static ClickHouseHttpConnection createConnection(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        HttpConnectionProvider provider = (HttpConnectionProvider)((Object)request.getConfig().getOption((ClickHouseOption)ClickHouseHttpOption.CONNECTION_PROVIDER));
        try {
            return provider == null || provider == HttpConnectionProvider.HTTP_URL_CONNECTION ? new HttpUrlConnectionImpl(server, request, executor) : new HttpClientConnectionImpl(server, request, executor);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            return new HttpUrlConnectionImpl(server, request, executor);
        }
    }
}

