/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.prompt.handler;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.plugin.AiPromptConfig;
import org.apache.shenyu.common.dto.convert.rule.AiPromptHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class AiPromptPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, AiPromptHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && pluginData.getEnabled().booleanValue()) {
            AiPromptConfig aiPromptConfig = (AiPromptConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), AiPromptConfig.class);
            if (Objects.isNull(aiPromptConfig)) {
                return;
            }
            Singleton.INST.single(AiPromptConfig.class, (Object)aiPromptConfig);
        }
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            AiPromptHandle aiPromptHandle = (AiPromptHandle)GsonUtils.getInstance().fromJson(s, AiPromptHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)aiPromptHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.AI_PROMPT.getName();
    }
}

