/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.atomic;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicSerializer
extends AbstractSerializer {
    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (obj == null) {
            out.writeNull();
            return;
        }
        if (obj instanceof AtomicBoolean) {
            this.doWrite(obj, "value", out);
        } else if (obj instanceof AtomicInteger) {
            this.doWrite(obj, "value", out);
        } else if (obj instanceof AtomicLong) {
            this.doWrite(obj, "value", out);
        } else if (obj instanceof AtomicReference) {
            this.doWrite(obj, "value", out);
        } else if (obj instanceof AtomicIntegerArray) {
            this.doWrite(obj, "array", out);
        } else if (obj instanceof AtomicLongArray) {
            this.doWrite(obj, "array", out);
        } else if (obj instanceof AtomicReferenceArray) {
            this.doWrite(obj, "array", out);
        } else {
            throw new UnsupportedOperationException(String.valueOf(this));
        }
    }

    protected void doWrite(Object obj, String fieldName, AbstractHessianOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        int ref = out.writeObjectBegin(cl.getName());
        if (ref < -1) {
            out.writeString(fieldName);
            this.writeFieldValue(obj, out);
        } else {
            if (ref == -1) {
                out.writeClassFieldLength(1);
                out.writeString(fieldName);
                out.writeObjectBegin(cl.getName());
            }
            this.writeFieldValue(obj, out);
        }
    }

    private void writeFieldValue(Object obj, AbstractHessianOutput out) throws IOException {
        if (obj instanceof AtomicInteger) {
            out.writeInt(((AtomicInteger)obj).get());
        } else if (obj instanceof AtomicLong) {
            out.writeLong(((AtomicLong)obj).get());
        } else if (obj instanceof AtomicBoolean) {
            out.writeInt(((AtomicBoolean)obj).get() ? 1 : 0);
        } else if (obj instanceof AtomicReference) {
            out.writeObject(((AtomicReference)obj).get());
        } else if (obj instanceof AtomicIntegerArray) {
            AtomicIntegerArray array = (AtomicIntegerArray)obj;
            int len = array.length();
            int[] tmp = new int[len];
            for (int i = 0; i < len; ++i) {
                tmp[i] = array.get(i);
            }
            out.writeObject(tmp);
        } else if (obj instanceof AtomicLongArray) {
            AtomicLongArray array = (AtomicLongArray)obj;
            int len = array.length();
            long[] tmp = new long[len];
            for (int i = 0; i < len; ++i) {
                tmp[i] = array.get(i);
            }
            out.writeObject(tmp);
        } else if (obj instanceof AtomicReferenceArray) {
            AtomicReferenceArray array = (AtomicReferenceArray)obj;
            int len = array.length();
            Object[] tmp = new Object[len];
            for (int i = 0; i < len; ++i) {
                tmp[i] = array.get(i);
            }
            out.writeObject(tmp);
        }
    }
}

