/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian;

import com.alipay.hessian.ClassNameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassNameResolver {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    List<ClassNameFilter> filters = null;

    public void addFilter(ClassNameFilter classNameFilter) {
        this.writeLock.lock();
        try {
            if (this.filters == null) {
                this.filters = new ArrayList<ClassNameFilter>();
            }
            this.filters.add(classNameFilter);
            Collections.sort(this.filters, new Comparator<ClassNameFilter>(){

                @Override
                public int compare(ClassNameFilter o1, ClassNameFilter o2) {
                    return o1.order() - o2.order();
                }
            });
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeFilter(ClassNameFilter classNameFilter) {
        this.writeLock.lock();
        try {
            if (this.filters != null) {
                this.filters.remove(classNameFilter);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(String className) throws IOException {
        this.readLock.lock();
        try {
            if (this.filters == null || this.filters.isEmpty()) {
                String string = className;
                return string;
            }
            String cls = className;
            for (ClassNameFilter filter : this.filters) {
                cls = filter.resolve(cls);
            }
            String string = cls;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

