/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.middleware.parent;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractDigestSpanEncoder
implements SpanEncoder<SofaTracerSpan> {
    @Override
    public String encode(SofaTracerSpan span) throws IOException {
        if ("false".equalsIgnoreCase(SofaTracerConfiguration.getProperty("global_json_format_output"))) {
            return this.encodeXsbSpan(span);
        }
        return this.encodeJsbSpan(span);
    }

    private String encodeJsbSpan(SofaTracerSpan span) {
        JsonStringBuilder jsb = new JsonStringBuilder();
        this.appendJsonCommonSlot(jsb, span);
        this.appendComponentSlot(null, jsb, span);
        jsb.append("sys.baggage", this.baggageSystemSerialized(span.getSofaTracerSpanContext()));
        jsb.appendEnd("biz.baggage", this.baggageSerialized(span.getSofaTracerSpanContext()));
        return jsb.toString();
    }

    private String encodeXsbSpan(SofaTracerSpan span) {
        XStringBuilder xsb = new XStringBuilder();
        this.appendXsbCommonSlot(xsb, span);
        this.appendComponentSlot(xsb, null, span);
        xsb.append(this.baggageSystemSerialized(span.getSofaTracerSpanContext()));
        xsb.appendEnd(this.baggageSerialized(span.getSofaTracerSpanContext()));
        return xsb.toString();
    }

    protected void appendComponentSlot(XStringBuilder xsb, JsonStringBuilder jsb, SofaTracerSpan span) {
    }

    protected String baggageSystemSerialized(SofaTracerSpanContext spanContext) {
        return spanContext.getSysSerializedBaggage();
    }

    protected String baggageSerialized(SofaTracerSpanContext spanContext) {
        return spanContext.getBizSerializedBaggage();
    }

    protected void appendJsonCommonSlot(JsonStringBuilder jsb, SofaTracerSpan span) {
        SofaTracerSpanContext context = span.getSofaTracerSpanContext();
        Map<String, String> tagWithStr = span.getTagsWithStr();
        jsb.appendBegin("time", Timestamp.format(span.getEndTime()));
        jsb.append("local.app", tagWithStr.get("local.app"));
        jsb.append("traceId", context.getTraceId());
        jsb.append("spanId", context.getSpanId());
        jsb.append(Tags.SPAN_KIND.getKey(), tagWithStr.get(Tags.SPAN_KIND.getKey()));
        jsb.append("result.code", tagWithStr.get("result.code"));
        jsb.append("current.thread.name", tagWithStr.get("current.thread.name"));
        jsb.append("time.cost.milliseconds", span.getEndTime() - span.getStartTime() + "ms");
    }

    protected void appendXsbCommonSlot(XStringBuilder xsb, SofaTracerSpan span) {
        SofaTracerSpanContext context = span.getSofaTracerSpanContext();
        Map<String, String> tagWithStr = span.getTagsWithStr();
        xsb.append(Timestamp.format(span.getEndTime()));
        xsb.append(tagWithStr.get("local.app"));
        xsb.append(context.getTraceId());
        xsb.append(context.getSpanId());
        xsb.append(tagWithStr.get(Tags.SPAN_KIND.getKey()));
        xsb.append(tagWithStr.get("result.code"));
        xsb.append(tagWithStr.get("current.thread.name"));
        xsb.append(span.getEndTime() - span.getStartTime() + "ms");
    }
}

