/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderPrimitive;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;

public final class ObjectReaderImplObject
extends ObjectReaderPrimitive {
    public static final ObjectReaderImplObject INSTANCE = new ObjectReaderImplObject();

    public ObjectReaderImplObject() {
        super(Object.class);
    }

    @Override
    public Object createInstance(long features) {
        return new JSONObject();
    }

    @Override
    public Object createInstance(Collection collection, long features) {
        return collection;
    }

    @Override
    public Object createInstance(Map map, long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Object typeKey = map.get(this.getTypeKey());
        if (typeKey instanceof String) {
            String typeName = (String)typeKey;
            long typeHash = Fnv.hashCode64(typeName);
            ObjectReader reader = null;
            if ((features & JSONReader.Feature.SupportAutoType.mask) != 0L) {
                reader = this.autoType(provider, typeHash);
            }
            if (reader == null && (reader = provider.getObjectReader(typeName, this.getObjectClass(), features | this.getFeatures())) == null) {
                throw new JSONException("No suitable ObjectReader found for" + typeName);
            }
            if (reader != this) {
                return reader.createInstance(map, features);
            }
        }
        return map;
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        HashSet value;
        if (jsonReader.jsonb) {
            return jsonReader.readAny();
        }
        JSONReader.Context context = jsonReader.getContext();
        long contextFeatures = features | context.getFeatures();
        String typeName = null;
        if (jsonReader.isObject()) {
            Supplier<Map> objectSupplier;
            jsonReader.nextIfObjectStart();
            long hash = 0L;
            if (jsonReader.isString() && (hash = jsonReader.readFieldNameHashCode()) == HASH_TYPE) {
                ObjectReader autoTypeObjectReader;
                boolean supportAutoType = context.isEnabled(JSONReader.Feature.SupportAutoType);
                if (supportAutoType) {
                    ClassLoader classLoader;
                    ClassLoader objectClassLoader;
                    Class objectClass;
                    long typeHash = jsonReader.readTypeHashCode();
                    autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                    if (autoTypeObjectReader != null && (objectClass = autoTypeObjectReader.getObjectClass()) != null && (objectClassLoader = objectClass.getClassLoader()) != (classLoader = Thread.currentThread().getContextClassLoader())) {
                        Class<?> contextClass = null;
                        typeName = jsonReader.getString();
                        try {
                            if (classLoader == null) {
                                classLoader = this.getClass().getClassLoader();
                            }
                            contextClass = classLoader.loadClass(typeName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (!objectClass.equals(contextClass)) {
                            autoTypeObjectReader = context.getObjectReader(contextClass);
                        }
                    }
                    if (autoTypeObjectReader == null) {
                        typeName = jsonReader.getString();
                        autoTypeObjectReader = context.getObjectReaderAutoType(typeName, null);
                    }
                } else {
                    typeName = jsonReader.readString();
                    autoTypeObjectReader = context.getObjectReaderAutoType(typeName, null);
                    if (autoTypeObjectReader == null && jsonReader.getContext().isEnabled(JSONReader.Feature.ErrorOnNotSupportAutoType)) {
                        throw new JSONException(jsonReader.info("autoType not support : " + typeName));
                    }
                }
                if (autoTypeObjectReader != null) {
                    jsonReader.setTypeRedirect(true);
                    return autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, features);
                }
            }
            Map<Object, Object> object = (objectSupplier = jsonReader.getContext().getObjectSupplier()) != null ? objectSupplier.get() : (((features | context.getFeatures()) & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap<String, String>() : (Map)ObjectReaderImplMap.INSTANCE_OBJECT.createInstance(jsonReader.features(features)));
            if (typeName != null) {
                switch (typeName) {
                    case "java.util.ImmutableCollections$Map1": 
                    case "java.util.ImmutableCollections$MapN": {
                        break;
                    }
                    default: {
                        object.put("@type", typeName);
                    }
                }
                hash = 0L;
            }
            int i = 0;
            while (!jsonReader.nextIfObjectEnd()) {
                Object origin;
                Object value2;
                Object name;
                if (i == 0 && typeName == null && hash != 0L) {
                    name = jsonReader.getFieldName();
                } else if (jsonReader.isNumber()) {
                    name = jsonReader.readNumber();
                    jsonReader.nextIfMatch(':');
                } else {
                    name = jsonReader.readFieldName();
                }
                if (name == null) {
                    char current = jsonReader.current();
                    if (current == '{' || current == '[') {
                        name = jsonReader.readAny();
                        if (!jsonReader.nextIfMatch(':')) {
                            throw new JSONException(jsonReader.info("illegal input"));
                        }
                    } else {
                        name = jsonReader.readFieldNameUnquote();
                        if (jsonReader.current() == ':') {
                            jsonReader.next();
                        }
                    }
                }
                switch (jsonReader.current()) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value2 = jsonReader.readNumber();
                        break;
                    }
                    case '[': {
                        value2 = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        value2 = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        value2 = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        value2 = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        value2 = jsonReader.readNullOrNewDate();
                        break;
                    }
                    case 'S': {
                        if (jsonReader.nextIfSet()) {
                            value2 = jsonReader.read(HashSet.class);
                            break;
                        }
                        throw new JSONException(jsonReader.info());
                    }
                    default: {
                        throw new JSONException(jsonReader.info());
                    }
                }
                if ((value2 != null || (contextFeatures & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = object.put(name, value2)) != null && (contextFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value2);
                        object.put(name, origin);
                    } else {
                        JSONArray array = JSONArray.of(origin, value2);
                        object.put(name, array);
                    }
                }
                ++i;
            }
            jsonReader.nextIfComma();
            return object;
        }
        char ch = jsonReader.current();
        if (ch == '/') {
            jsonReader.skipComment();
            ch = jsonReader.current();
        }
        switch (ch) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                value = jsonReader.readNumber();
                break;
            }
            case '[': {
                value = jsonReader.readArray();
                break;
            }
            case '\"': 
            case '\'': {
                value = jsonReader.readString();
                break;
            }
            case 'f': 
            case 't': {
                value = jsonReader.readBoolValue();
                break;
            }
            case 'n': {
                value = jsonReader.readNullOrNewDate();
                break;
            }
            case 'S': {
                if (jsonReader.nextIfSet()) {
                    HashSet set = new HashSet();
                    jsonReader.read(set);
                    value = set;
                    break;
                }
                throw new JSONException(jsonReader.info());
            }
            default: {
                throw new JSONException(jsonReader.info());
            }
        }
        return value;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeObjectReader;
        byte type = jsonReader.getType();
        if (type >= 73 && type <= 125) {
            return jsonReader.readString();
        }
        if (type == -110 && (autoTypeObjectReader = jsonReader.checkAutoType(Object.class, 0L, features)) != null) {
            return autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (type == -81) {
            jsonReader.next();
            return null;
        }
        return jsonReader.readAny();
    }
}

