/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.ParamType;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.BaseConsumerParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.ConsumerParseContext;
import org.apache.dubbo.rpc.protocol.rest.util.DataParseUtils;

@Activate(value={"consumer-form"})
public class FormConsumerParamParser
implements BaseConsumerParamParser {
    @Override
    public void parse(ConsumerParseContext parseContext, ArgInfo argInfo) {
        List<Object> args = parseContext.getArgs();
        RequestTemplate requestTemplate = parseContext.getRequestTemplate();
        Object value = args.get(argInfo.getIndex());
        if (value == null) {
            return;
        }
        HashMap<String, List<String>> tmp = new HashMap<String, List<String>>();
        if (DataParseUtils.isTextType(value.getClass())) {
            tmp.put(argInfo.getAnnotationNameAttribute(), Arrays.asList(String.valueOf(value)));
            requestTemplate.body(tmp, Map.class);
        } else if (value instanceof Map) {
            requestTemplate.body(value, Map.class);
        } else {
            Set<String> allFieldNames = ReflectUtils.getAllFieldNames(value.getClass());
            allFieldNames.stream().forEach(entry -> {
                Object fieldValue = ReflectUtils.getFieldValue(value, entry);
                tmp.put(String.valueOf(entry), Arrays.asList(String.valueOf(fieldValue)));
            });
            requestTemplate.body(tmp, Map.class);
        }
        Collection<String> headers = requestTemplate.getHeaders("Content-Type");
        if (CollectionUtils.isEmpty(headers)) {
            requestTemplate.addHeader("Content-Type", MediaType.APPLICATION_FORM_URLENCODED_VALUE.value);
        }
    }

    @Override
    public boolean paramTypeMatch(ArgInfo argInfo) {
        return ParamType.FORM.supportAnno(argInfo.getParamAnnotationType());
    }
}

