/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.rpc.GracefulShutdown;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;

public class DubboGracefulShutdown
implements GracefulShutdown {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboGracefulShutdown.class);
    private final DubboProtocol dubboProtocol;

    public DubboGracefulShutdown(DubboProtocol dubboProtocol) {
        this.dubboProtocol = dubboProtocol;
    }

    @Override
    public void readonly() {
        this.sendEvent("R");
    }

    @Override
    public void writeable() {
        this.sendEvent("W");
    }

    private void sendEvent(String event) {
        try {
            for (ProtocolServer server : this.dubboProtocol.getServers()) {
                Collection<Channel> channels = server.getRemotingServer().getChannels();
                Request request = new Request();
                request.setEvent(event);
                request.setTwoWay(false);
                request.setVersion(Version.getProtocolVersion());
                for (Channel channel : channels) {
                    try {
                        if (!channel.isConnected()) continue;
                        channel.send(request, channel.getUrl().getParameter("channel.readonly.sent", true));
                    }
                    catch (RemotingException e) {
                        if (e.getCause() instanceof ClosedChannelException) continue;
                        logger.warn("6-13", "", "", "send cannot write message error.", e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("6-13", "", "", "send cannot write message error.", e);
        }
    }
}

