/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.convert.multiple;

import java.lang.reflect.Array;
import org.apache.dubbo.common.convert.Converter;
import org.apache.dubbo.common.convert.ConverterUtil;
import org.apache.dubbo.common.convert.multiple.StringToMultiValueConverter;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class StringToArrayConverter
implements StringToMultiValueConverter {
    private ConverterUtil converterUtil;

    public StringToArrayConverter(FrameworkModel frameworkModel) {
        this.converterUtil = frameworkModel.getBeanFactory().getBean(ConverterUtil.class);
    }

    @Override
    public boolean accept(Class<String> type, Class<?> multiValueType) {
        return multiValueType != null && multiValueType.isArray();
    }

    @Override
    public Object convert(String[] segments, int size, Class<?> targetType, Class<?> elementType) {
        Class<?> componentType = targetType.getComponentType();
        Converter<?, ?> converter = this.converterUtil.getConverter(String.class, componentType);
        Object array = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, converter.convert(segments[i]));
        }
        return array;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

