/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.tcp.connection;

import io.netty.channel.Channel;
import org.apache.shenyu.protocol.tcp.connection.Bridge;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.netty.Connection;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;

public class TcpConnectionBridge
implements Bridge {
    private static final Logger LOG = LoggerFactory.getLogger(TcpConnectionBridge.class);

    @Override
    public void bridge(Connection server, Connection client) {
        Disposable requestDisposable = this.bridge(server.inbound(), client.outbound());
        Disposable responseDisposable = this.bridge(client.inbound(), server.outbound());
        Disposable[] disposableArray = new Disposable[3];
        disposableArray[0] = requestDisposable;
        disposableArray[1] = responseDisposable;
        disposableArray[2] = () -> ((Channel)client.channel()).close();
        server.onDispose((Disposable)Disposables.composite((Disposable[])disposableArray));
        Disposable[] disposableArray2 = new Disposable[3];
        disposableArray2[0] = requestDisposable;
        disposableArray2[1] = responseDisposable;
        disposableArray2[2] = () -> ((Channel)server.channel()).close();
        client.onDispose((Disposable)Disposables.composite((Disposable[])disposableArray2));
    }

    private Disposable bridge(NettyInbound inbound, NettyOutbound outbound) {
        return outbound.send((Publisher)inbound.receive().retain()).then().subscribe();
    }
}

