/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.kafka.handler;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.handler.AbstractLogPluginDataHandler;
import org.apache.shenyu.plugin.logging.common.utils.LogCollectConfigUtils;
import org.apache.shenyu.plugin.logging.kafka.cache.KafkaClientCache;
import org.apache.shenyu.plugin.logging.kafka.client.KafkaLogCollectClient;
import org.apache.shenyu.plugin.logging.kafka.collector.KafkaLogCollector;
import org.apache.shenyu.plugin.logging.kafka.config.KafkaLogCollectConfig;

public class LoggingKafkaPluginDataHandler
extends AbstractLogPluginDataHandler<KafkaLogCollectConfig.KafkaLogConfig, KafkaLogCollectConfig.LogApiConfig> {
    private static final KafkaLogCollectClient KAFKA_LOG_COLLECT_CLIENT = new KafkaLogCollectClient();
    private static final AtomicBoolean MULTI_CLIENT = new AtomicBoolean(false);

    protected LogCollector logCollector() {
        return KafkaLogCollector.getInstance();
    }

    public static boolean getMultiClient() {
        return MULTI_CLIENT.get();
    }

    protected void doRefreshConfig(KafkaLogCollectConfig.KafkaLogConfig globalLogConfig) {
        KafkaLogCollectConfig.INSTANCE.setKafkaLogConfig(globalLogConfig);
        KAFKA_LOG_COLLECT_CLIENT.initClient(globalLogConfig);
    }

    public String pluginNamed() {
        return PluginEnum.LOGGING_KAFKA.getName();
    }

    public static KafkaLogCollectClient getKafkaLogCollectClient() {
        return KAFKA_LOG_COLLECT_CLIENT;
    }

    public void handlerSelector(SelectorData selectorData) {
        KafkaLogCollectConfig.LogApiConfig oConfig;
        Map kafkaJsonMap = GsonUtils.getInstance().convertToMap(selectorData.getHandle());
        if (Objects.isNull(kafkaJsonMap)) {
            return;
        }
        Object hostObj = kafkaJsonMap.get("bootstrapServer");
        if (Objects.isNull(hostObj) || !(hostObj instanceof String) || ((String)hostObj).trim().isEmpty()) {
            KafkaClientCache.getInstance().invalidate(selectorData.getId());
            Optional.ofNullable(KafkaClientCache.getInstance().getClientCache()).filter(Map::isEmpty).ifPresent(map -> MULTI_CLIENT.set(false));
            return;
        }
        KafkaLogCollectConfig.LogApiConfig nConfig = (KafkaLogCollectConfig.LogApiConfig)((Object)GsonUtils.getInstance().fromJson(selectorData.getHandle(), KafkaLogCollectConfig.LogApiConfig.class));
        if (Objects.equals((Object)nConfig, (Object)(oConfig = (KafkaLogCollectConfig.LogApiConfig)((Object)LoggingKafkaPluginDataHandler.getSelectApiConfigMap().get(selectorData.getId()))))) {
            return;
        }
        KafkaClientCache.getInstance().invalidate(selectorData.getId());
        KafkaClientCache.getInstance().initKafkaClient(selectorData.getId(), nConfig);
        MULTI_CLIENT.set(true);
        if (StringUtils.isNotEmpty((CharSequence)nConfig.getSampleRate())) {
            nConfig.setSampler(LogCollectConfigUtils.setSampler((String)nConfig.getSampleRate()));
        }
        LoggingKafkaPluginDataHandler.getSelectApiConfigMap().put(selectorData.getId(), nConfig);
    }

    public void removePlugin(PluginData pluginData) {
        KafkaClientCache.getInstance().invalidateAll();
        super.removePlugin(pluginData);
    }

    public void removeSelector(SelectorData selectorData) {
        KafkaClientCache.getInstance().invalidate(selectorData.getId());
        super.removeSelector(selectorData);
    }
}

