/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.AbstractBoltClient;
import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventListener;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.ConnectionManager;
import com.alipay.remoting.ConnectionMonitorStrategy;
import com.alipay.remoting.ConnectionSelectStrategy;
import com.alipay.remoting.DefaultClientConnectionManager;
import com.alipay.remoting.DefaultConnectionMonitor;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.LifeCycleException;
import com.alipay.remoting.RandomSelectStrategy;
import com.alipay.remoting.ReconnectManager;
import com.alipay.remoting.Reconnector;
import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.ScheduledDisconnectStrategy;
import com.alipay.remoting.Url;
import com.alipay.remoting.config.BoltClientOption;
import com.alipay.remoting.config.BoltGenericOption;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RpcAddressParser;
import com.alipay.remoting.rpc.RpcClientRemoting;
import com.alipay.remoting.rpc.RpcCommandFactory;
import com.alipay.remoting.rpc.RpcConnectionEventHandler;
import com.alipay.remoting.rpc.RpcConnectionFactory;
import com.alipay.remoting.rpc.RpcRemoting;
import com.alipay.remoting.rpc.RpcResponseFuture;
import com.alipay.remoting.rpc.RpcTaskScanner;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.rpc.protocol.UserProcessorRegisterHelper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class RpcClient
extends AbstractBoltClient {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private final RpcTaskScanner taskScanner = new RpcTaskScanner();
    private final ConcurrentHashMap<String, UserProcessor<?>> userProcessors = new ConcurrentHashMap();
    private final ConnectionEventHandler connectionEventHandler = new RpcConnectionEventHandler(this);
    private final ConnectionEventListener connectionEventListener = new ConnectionEventListener();
    private ConnectionManager connectionManager;
    private Reconnector reconnectManager;
    private RemotingAddressParser addressParser;
    private DefaultConnectionMonitor connectionMonitor;
    private ConnectionMonitorStrategy monitorStrategy;
    protected RpcRemoting rpcRemoting;

    @Deprecated
    public void init() {
        this.startup();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.connectionManager.shutdown();
        logger.warn("Close all connections from client side!");
        this.taskScanner.shutdown();
        logger.warn("Rpc client shutdown!");
        if (this.reconnectManager != null) {
            this.reconnectManager.shutdown();
        }
        if (this.connectionMonitor != null) {
            this.connectionMonitor.shutdown();
        }
        for (UserProcessor<?> userProcessor : this.userProcessors.values()) {
            if (!userProcessor.isStarted()) continue;
            userProcessor.shutdown();
        }
    }

    @Override
    public void startup() throws LifeCycleException {
        ConnectionSelectStrategy connectionSelectStrategy;
        super.startup();
        for (UserProcessor<?> userProcessor : this.userProcessors.values()) {
            if (userProcessor.isStarted()) continue;
            userProcessor.startup();
        }
        if (this.addressParser == null) {
            this.addressParser = new RpcAddressParser();
        }
        if ((connectionSelectStrategy = this.option(BoltGenericOption.CONNECTION_SELECT_STRATEGY)) == null) {
            connectionSelectStrategy = new RandomSelectStrategy(this);
        }
        if (this.connectionManager == null) {
            DefaultClientConnectionManager defaultConnectionManager = new DefaultClientConnectionManager(connectionSelectStrategy, new RpcConnectionFactory(this.userProcessors, this), this.connectionEventHandler, this.connectionEventListener);
            defaultConnectionManager.setAddressParser(this.addressParser);
            defaultConnectionManager.startup();
            this.connectionManager = defaultConnectionManager;
        }
        this.rpcRemoting = new RpcClientRemoting(new RpcCommandFactory(), this.addressParser, this.connectionManager);
        this.taskScanner.add(this.connectionManager);
        this.taskScanner.startup();
        if (this.isConnectionMonitorSwitchOn()) {
            this.connectionMonitor = this.monitorStrategy == null ? new DefaultConnectionMonitor(new ScheduledDisconnectStrategy(), this.connectionManager) : new DefaultConnectionMonitor(this.monitorStrategy, this.connectionManager);
            this.connectionMonitor.startup();
            logger.warn("Switch on connection monitor");
        }
        if (this.isReconnectSwitchOn()) {
            this.reconnectManager = new ReconnectManager(this.connectionManager);
            this.reconnectManager.startup();
            this.connectionEventHandler.setReconnector(this.reconnectManager);
            logger.warn("Switch on reconnect manager");
        }
    }

    @Override
    public void oneway(String address, Object request) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.oneway(address, request, null);
    }

    @Override
    public void oneway(String address, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.oneway(address, request, invokeContext);
    }

    @Override
    public void oneway(Url url, Object request) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.oneway(url, request, null);
    }

    @Override
    public void oneway(Url url, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.oneway(url, request, invokeContext);
    }

    @Override
    public void oneway(Connection conn, Object request) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.oneway(conn, request, null);
    }

    @Override
    public void oneway(Connection conn, Object request, InvokeContext invokeContext) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.oneway(conn, request, invokeContext);
    }

    @Override
    public Object invokeSync(String address, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(address, request, null, timeoutMillis);
    }

    @Override
    public Object invokeSync(String address, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(address, request, invokeContext, timeoutMillis);
    }

    @Override
    public Object invokeSync(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.invokeSync(url, request, null, timeoutMillis);
    }

    @Override
    public Object invokeSync(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(url, request, invokeContext, timeoutMillis);
    }

    @Override
    public Object invokeSync(Connection conn, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(conn, request, null, timeoutMillis);
    }

    @Override
    public Object invokeSync(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(conn, request, invokeContext, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(String address, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(address, request, null, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(String address, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(address, request, invokeContext, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(url, request, null, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(url, request, invokeContext, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(conn, request, null, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(conn, request, invokeContext, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(String address, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(address, request, null, invokeCallback, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(String address, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(address, request, invokeContext, invokeCallback, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(Url url, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(url, request, null, invokeCallback, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(Url url, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(url, request, invokeContext, invokeCallback, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(Connection conn, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(conn, request, null, invokeCallback, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(Connection conn, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(conn, request, invokeContext, invokeCallback, timeoutMillis);
    }

    @Override
    public void addConnectionEventProcessor(ConnectionEventType type, ConnectionEventProcessor processor) {
        this.connectionEventListener.addConnectionEventProcessor(type, processor);
    }

    @Override
    public void registerUserProcessor(UserProcessor<?> processor) {
        UserProcessorRegisterHelper.registerUserProcessor(processor, this.userProcessors);
        if (this.isStarted() && !processor.isStarted()) {
            processor.startup();
        }
    }

    @Override
    public Connection createStandaloneConnection(String ip, int port, int connectTimeout) throws RemotingException {
        this.ensureStarted();
        return this.connectionManager.create(ip, port, connectTimeout);
    }

    @Override
    public Connection createStandaloneConnection(String address, int connectTimeout) throws RemotingException {
        this.ensureStarted();
        return this.connectionManager.create(address, connectTimeout);
    }

    @Override
    public void closeStandaloneConnection(Connection conn) {
        this.ensureStarted();
        if (null != conn) {
            conn.close();
        }
    }

    @Override
    public Connection getConnection(String address, int connectTimeout) throws RemotingException, InterruptedException {
        this.ensureStarted();
        Url url = this.addressParser.parse(address);
        return this.getConnection(url, connectTimeout);
    }

    @Override
    public Connection getConnection(Url url, int connectTimeout) throws RemotingException, InterruptedException {
        this.ensureStarted();
        url.setConnectTimeout(connectTimeout);
        return this.connectionManager.getAndCreateIfAbsent(url);
    }

    @Override
    public Map<String, List<Connection>> getAllManagedConnections() {
        this.ensureStarted();
        return this.connectionManager.getAll();
    }

    @Override
    public boolean checkConnection(String address) {
        return this.checkConnection(address, false);
    }

    @Override
    public boolean checkConnection(String address, boolean createIfAbsent) {
        return this.checkConnection(address, createIfAbsent, false);
    }

    @Override
    public boolean checkConnection(String address, boolean createIfAbsent, boolean createAsync) {
        this.ensureStarted();
        Url url = this.addressParser.parse(address);
        Connection conn = this.connectionManager.get(url.getUniqueKey());
        try {
            this.connectionManager.check(conn);
        }
        catch (Exception e) {
            logger.warn("check failed. address: {}, connection: {}", new Object[]{address, conn, e});
            if (createIfAbsent) {
                try {
                    if (createAsync) {
                        this.connectionManager.createConnectionInManagement(url);
                        return false;
                    }
                    Connection connection = this.connectionManager.getAndCreateIfAbsent(url);
                    try {
                        this.connectionManager.check(connection);
                        return true;
                    }
                    catch (Exception ex0) {
                        return false;
                    }
                }
                catch (Exception ex) {
                    logger.warn("check failed and try create connection for {} also failed.", (Object)address, (Object)e);
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void closeConnection(String addr) {
        this.ensureStarted();
        Url url = this.addressParser.parse(addr);
        if (this.isReconnectSwitchOn() && this.reconnectManager != null) {
            this.reconnectManager.disableReconnect(url);
        }
        this.connectionManager.remove(url.getUniqueKey());
    }

    @Override
    public void closeConnection(Url url) {
        this.ensureStarted();
        if (this.isReconnectSwitchOn() && this.reconnectManager != null) {
            this.reconnectManager.disableReconnect(url);
        }
        this.connectionManager.remove(url.getUniqueKey());
    }

    @Override
    public void enableConnHeartbeat(String address) {
        this.ensureStarted();
        Url url = this.addressParser.parse(address);
        this.enableConnHeartbeat(url);
    }

    @Override
    public void enableConnHeartbeat(Url url) {
        this.ensureStarted();
        if (null != url) {
            this.connectionManager.enableHeartbeat(this.connectionManager.get(url.getUniqueKey()));
        }
    }

    @Override
    public void disableConnHeartbeat(String address) {
        this.ensureStarted();
        Url url = this.addressParser.parse(address);
        this.disableConnHeartbeat(url);
    }

    @Override
    public void disableConnHeartbeat(Url url) {
        this.ensureStarted();
        if (null != url) {
            this.connectionManager.disableHeartbeat(this.connectionManager.get(url.getUniqueKey()));
        }
    }

    @Override
    @Deprecated
    public void enableReconnectSwitch() {
        this.option(BoltClientOption.CONN_RECONNECT_SWITCH, true);
    }

    @Override
    @Deprecated
    public void disableReconnectSwith() {
        this.option(BoltClientOption.CONN_RECONNECT_SWITCH, false);
    }

    @Override
    @Deprecated
    public boolean isReconnectSwitchOn() {
        return this.option(BoltClientOption.CONN_RECONNECT_SWITCH);
    }

    @Override
    @Deprecated
    public void enableConnectionMonitorSwitch() {
        this.option(BoltClientOption.CONN_MONITOR_SWITCH, true);
    }

    @Override
    @Deprecated
    public void disableConnectionMonitorSwitch() {
        this.option(BoltClientOption.CONN_MONITOR_SWITCH, false);
    }

    @Override
    @Deprecated
    public boolean isConnectionMonitorSwitchOn() {
        return this.option(BoltClientOption.CONN_MONITOR_SWITCH);
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public RemotingAddressParser getAddressParser() {
        return this.addressParser;
    }

    @Override
    public void setAddressParser(RemotingAddressParser addressParser) {
        this.addressParser = addressParser;
    }

    @Override
    public void setMonitorStrategy(ConnectionMonitorStrategy monitorStrategy) {
        this.monitorStrategy = monitorStrategy;
    }
}

